/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.api;

import com.startapp.simple.bloomfilter.algo.AlwaysNotContainsBloomContainer;
import com.startapp.simple.bloomfilter.algo.BitSetHandling;
import com.startapp.simple.bloomfilter.algo.BloomContainer;
import com.startapp.simple.bloomfilter.algo.BloomContainerWithValidBitSet;
import com.startapp.simple.bloomfilter.algo.OpenBitSet;
import com.startapp.simple.bloomfilter.codec.StringUtils;
import com.startapp.simple.bloomfilter.compression.TokenCompression;
import com.startapp.simple.bloomfilter.creation.DeserializerTokenToBitSet;
import com.startapp.simple.bloomfilter.creation.Serializer;
import com.startapp.simple.bloomfilter.creation.TokenToBitSet;
import com.startapp.simple.bloomfilter.data.TokenData;
import com.startapp.simple.bloomfilter.parsing.TokenBuilder;
import com.startapp.simple.bloomfilter.parsing.TokenParser;
import com.startapp.simple.bloomfilter.version.BloomVersion;
import com.startapp.simple.bloomfilter.version.VersionFactoryHolder;
import java.util.List;

public class BloomFilterCreator {
    private static final String ALL_EXISTS_TOKEN = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final OpenBitSet BIT_SET_ALL_EXIST;
    private final TokenBuilder tokenBuilder;
    private final TokenParser tokenParser;
    private final VersionFactoryHolder versionFactoryHolder;

    public BloomFilterCreator() {
        Serializer serializer = new Serializer();
        this.versionFactoryHolder = new VersionFactoryHolder();
        this.tokenBuilder = new TokenBuilder(serializer, this.versionFactoryHolder);
        this.tokenParser = new TokenParser();
    }

    private BloomFilterCreator(TokenBuilder tokenBuilder, TokenParser tokenParser, VersionFactoryHolder versionFactoryHolder) {
        this.tokenBuilder = tokenBuilder;
        this.tokenParser = tokenParser;
        this.versionFactoryHolder = versionFactoryHolder;
    }

    public BloomContainer fromToken(String token) {
        TokenCompression tokenCompression;
        String decompressed;
        if (StringUtils.isBlank(token)) {
            return new AlwaysNotContainsBloomContainer(null);
        }
        TokenData tokenData = this.tokenParser.fromTokenString(token);
        if (tokenData == null) {
            return new AlwaysNotContainsBloomContainer(null);
        }
        BloomVersion bloomVersion = tokenData.getBloomVersion();
        TokenToBitSet tokenToBitSet = this.versionFactoryHolder.getTokenToBitSet(bloomVersion);
        OpenBitSet openBitSet = tokenToBitSet.convert(decompressed = (tokenCompression = this.versionFactoryHolder.getTokenCompression(bloomVersion)).decompress(tokenData.bloom()));
        if (openBitSet == null) {
            return new AlwaysNotContainsBloomContainer(bloomVersion);
        }
        BitSetHandling bitSetHandlingOfVersion = this.versionFactoryHolder.getBitSetHandling(bloomVersion);
        return new BloomContainerWithValidBitSet(bitSetHandlingOfVersion, openBitSet, bloomVersion);
    }

    public String tokenFromContainer(BloomContainer bloomContainer) {
        BloomVersion versionOfContainer = bloomContainer.getBloomVersion();
        Serializer serializer = new Serializer();
        TokenBuilder tokenBuilderFromContainer = new TokenBuilder(serializer, this.versionFactoryHolder);
        return tokenBuilderFromContainer.asToken(versionOfContainer, bloomContainer.getBitSet(), System.currentTimeMillis());
    }

    public BloomContainer tokenWithAllExisting() {
        BitSetHandling bitSetHandling = this.versionFactoryHolder.getBitSetHandling(BloomVersion.FOUR);
        return new BloomContainerWithValidBitSet(bitSetHandling, BIT_SET_ALL_EXIST, BloomVersion.FOUR);
    }

    public String fromKeys(BloomVersion version, List<String> keys) {
        long time = System.currentTimeMillis();
        return this.createToken(version, keys, time);
    }

    public String fromKeys(List<String> keys) {
        long time = System.currentTimeMillis();
        return this.createToken(BloomVersion.FOUR, keys, time);
    }

    String createToken(BloomVersion version, List<String> keys, long time) {
        BitSetHandling bitSetHandling = this.versionFactoryHolder.getBitSetHandling(version);
        OpenBitSet bitSet = bitSetHandling.keysToBitSet(keys);
        return this.tokenBuilder.asToken(version, bitSet, time);
    }

    public long[] hashBytesOfKey(String key) {
        return this.hashBytesOfKey(BloomVersion.FOUR, key);
    }

    public long[] hashBytesOfKey(BloomVersion version, String key) {
        BitSetHandling bitSetHandling = this.versionFactoryHolder.getBitSetHandling(version);
        return bitSetHandling.hashBucketsFromApplication(key);
    }

    static BloomFilterCreator createForTesting(TokenBuilder tokenBuilder, TokenParser tokenParser, VersionFactoryHolder versionFactoryHolder) {
        return new BloomFilterCreator(tokenBuilder, tokenParser, versionFactoryHolder);
    }

    static {
        DeserializerTokenToBitSet tokenToBitSet = new DeserializerTokenToBitSet(BloomVersion.FOUR.getNumberOfHashes(), BloomVersion.FOUR.getSizeOfBucket());
        BIT_SET_ALL_EXIST = tokenToBitSet.convert(ALL_EXISTS_TOKEN);
    }
}

