/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.compression;

import com.startapp.simple.bloomfilter.codec.Base64;
import com.startapp.simple.bloomfilter.codec.IOUtils;
import com.startapp.simple.bloomfilter.compression.StringReplacer;
import com.startapp.simple.bloomfilter.compression.TokenCompression;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipBase64TokenCompression
implements TokenCompression {
    private final StringReplacer replacer;

    public GZipBase64TokenCompression(StringReplacer replacer) {
        this.replacer = replacer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String compress(String token) {
        GZIPOutputStream gZipOS = null;
        try {
            ByteArrayOutputStream byteArrOS = new ByteArrayOutputStream();
            gZipOS = new GZIPOutputStream(byteArrOS);
            gZipOS.write(token.getBytes());
            IOUtils.closeQuietly(gZipOS);
            byte[] byteArray = byteArrOS.toByteArray();
            String encodeBase64String = Base64.encodeBase64String(byteArray);
            String string = this.replacer.replaceToUrl(encodeBase64String);
            IOUtils.closeQuietly(gZipOS);
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            IOUtils.closeQuietly(gZipOS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decompress(String compressedToken) {
        String result = null;
        GZIPInputStream zi = null;
        try {
            zi = new GZIPInputStream(new ByteArrayInputStream(Base64.decodeBase64(this.replacer.replaceFromUrl(compressedToken))));
            result = IOUtils.toString(zi);
            if (zi != null) {
                zi.close();
            }
            String string = result;
            IOUtils.closeQuietly(zi);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly(zi);
        }
    }
}

