/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.creation;

import com.startapp.simple.bloomfilter.algo.OpenBitSet;
import com.startapp.simple.bloomfilter.creation.StringManipulations;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Serializer {
    private final StringManipulations stringManipulations = new StringManipulations();

    public String serialize(OpenBitSet bitSet) {
        int bitLength = bitSet.getNumWords();
        int pageCount = bitSet.getPageCount();
        ByteArrayOutputStream os = null;
        DataOutputStream dataOutput = null;
        try {
            os = new ByteArrayOutputStream();
            dataOutput = new DataOutputStream(os);
            for (int p = 0; p < pageCount; ++p) {
                long[] bits = bitSet.getPage(p);
                for (int i = 0; i < 4096 && bitLength-- > 0; ++i) {
                    dataOutput.writeLong(bits[i]);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("problem serializing bitSet", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.stringManipulations.bytesToHex(os.toByteArray());
    }
}

