/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.creation;

import com.startapp.simple.bloomfilter.algo.OpenBitSet;
import com.startapp.simple.bloomfilter.creation.StringManipulations;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class TokenToBitSet {
    private final StringManipulations stringManipulations = new StringManipulations();
    public static final String HIGH_PAGE_COUNT_EXCEPTION_TAG = "HighPageCountException";

    public OpenBitSet convert(String token) {
        if (null == token) {
            return null;
        }
        try {
            byte[] encodedFilter = this.stringManipulations.hexToByte(token);
            if (encodedFilter == null) {
                return null;
            }
            DataInput dataInput = this.createDataInput(encodedFilter);
            return this.createOpenBitSet(dataInput);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains(HIGH_PAGE_COUNT_EXCEPTION_TAG)) {
                System.err.println("HighPageCountException (PLM-2573) " + e.getMessage() + ", bad bloom token: " + token);
            }
            return null;
        }
    }

    protected void fillBitSet(DataInput dataInput, OpenBitSet bitSet, long bitLength) throws IOException {
        int pageCount = bitSet.getPageCount();
        for (int p = 0; p < pageCount; ++p) {
            long[] bits = bitSet.getPage(p);
            for (int i = 0; i < 4096 && bitLength-- > 0L; ++i) {
                bits[i] = dataInput.readLong();
            }
        }
    }

    protected DataInput createDataInput(byte[] encodedFilter) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(encodedFilter);
        DataInputStream dataInput = new DataInputStream(inputStream);
        return dataInput;
    }

    protected abstract OpenBitSet createOpenBitSet(DataInput var1) throws IOException;
}

