/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.data;

import com.startapp.simple.bloomfilter.version.BloomVersion;
import java.io.Serializable;

public class TokenData
implements Serializable {
    private static final long serialVersionUID = 1261418233150941470L;
    private final long timestamp;
    private final String bloom;
    private final BloomVersion version;

    public TokenData(BloomVersion version, long timestamp, String bloom) {
        this.version = version;
        this.timestamp = timestamp;
        this.bloom = bloom;
    }

    public String bloom() {
        return this.bloom;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String version() {
        return this.version.getVersion();
    }

    public boolean wasModified(TokenData otherTokenData) {
        if (this.version.equals((Object)otherTokenData.version)) {
            if (this.isNewerByTime(otherTokenData)) {
                return this.differentBloom(otherTokenData);
            }
            return false;
        }
        return this.isNewerByVersion(otherTokenData);
    }

    private boolean isNewerByTime(TokenData otherTokenData) {
        return this.timestamp - otherTokenData.timestamp > 0L;
    }

    private boolean isNewerByVersion(TokenData otherTokenData) {
        return this.version.ordinal() > otherTokenData.version.ordinal();
    }

    public BloomVersion getBloomVersion() {
        return this.version;
    }

    private boolean differentBloom(TokenData otherTokenData) {
        return !this.version.substringFromBloom(this.bloom).equals(otherTokenData.version.substringFromBloom(otherTokenData.bloom()));
    }

    public String toString() {
        return String.format("TokenData [version=%s, timestamp=%s, bloom=%s]", new Object[]{this.version, this.timestamp, this.bloom});
    }
}

