/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.parsing;

import com.startapp.simple.bloomfilter.algo.OpenBitSet;
import com.startapp.simple.bloomfilter.compression.TokenCompression;
import com.startapp.simple.bloomfilter.creation.Serializer;
import com.startapp.simple.bloomfilter.version.BloomVersion;
import com.startapp.simple.bloomfilter.version.VersionFactoryHolder;

public class TokenBuilder {
    public static final String TOKEN_DELIMITER = "-";
    private final Serializer serializer;
    private final VersionFactoryHolder versionFactoryHolder;

    public TokenBuilder(Serializer serializer, VersionFactoryHolder versionFactoryHolder) {
        this.versionFactoryHolder = versionFactoryHolder;
        this.serializer = serializer;
    }

    public String asToken(BloomVersion bloomVersion, OpenBitSet bitSet, long time) {
        try {
            String encodedFilter = this.serializer.serialize(bitSet);
            TokenCompression tokenCompression = this.versionFactoryHolder.getTokenCompression(bloomVersion);
            return time + TOKEN_DELIMITER + bloomVersion.getVersion() + TOKEN_DELIMITER + tokenCompression.compress(encodedFilter);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

