/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.parsing;

import com.startapp.simple.bloomfilter.data.TokenData;
import com.startapp.simple.bloomfilter.version.BloomVersion;
import java.util.regex.Pattern;

public class TokenParser {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");

    public TokenData fromTokenString(String token) {
        String bloom;
        long timestamp;
        BloomVersion version;
        String[] splittedToken = token.split("-");
        switch (splittedToken.length) {
            case 1: {
                version = BloomVersion.ZERO;
                timestamp = 0L;
                bloom = token;
                break;
            }
            case 2: {
                version = BloomVersion.THREE;
                if (!this.validTimestamp(splittedToken[0])) {
                    return null;
                }
                timestamp = Long.parseLong(splittedToken[0]);
                bloom = splittedToken[1];
                break;
            }
            case 3: {
                if (!this.validTimestamp(splittedToken[0])) {
                    return null;
                }
                timestamp = Long.parseLong(splittedToken[0]);
                version = this.versionByToken(splittedToken[1]);
                if (version == null) {
                    return null;
                }
                bloom = splittedToken[2];
                break;
            }
            default: {
                return null;
            }
        }
        return new TokenData(version, timestamp, bloom);
    }

    private boolean validTimestamp(String candidateTimestamp) {
        return NUMBER_PATTERN.matcher(candidateTimestamp).matches();
    }

    private BloomVersion versionByToken(String valueInToken) {
        if ("4".equals(valueInToken)) {
            return BloomVersion.FOUR;
        }
        if ("5".equals(valueInToken)) {
            return BloomVersion.FIVE;
        }
        return null;
    }
}

