/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.version;

public enum BloomVersion {
    ZERO("0", 1, 720),
    THREE("3.0", 1, 720){

        @Override
        public String substringFromBloom(String bloom) {
            int lengthOfBloom = bloom.length();
            if (lengthOfBloom > 20) {
                return bloom.substring(0, lengthOfBloom - 20);
            }
            return bloom;
        }
    }
    ,
    FOUR("4", 3, 3500),
    FIVE("5", 3, 1000000);

    private final String version;
    private final int numberOfHashes;
    private final int sizeOfBucket;

    private BloomVersion(String version, int numberOfHashes, int sizeOfBucket) {
        this.version = version;
        this.numberOfHashes = numberOfHashes;
        this.sizeOfBucket = sizeOfBucket;
    }

    public String getVersion() {
        return this.version;
    }

    public int getNumberOfHashes() {
        return this.numberOfHashes;
    }

    public int getSizeOfBucket() {
        return this.sizeOfBucket;
    }

    public String substringFromBloom(String bloom) {
        return bloom;
    }
}

