/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.version;

import com.startapp.simple.bloomfilter.algo.BitSetHandling;
import com.startapp.simple.bloomfilter.compression.TokenCompression;
import com.startapp.simple.bloomfilter.creation.TokenToBitSet;
import com.startapp.simple.bloomfilter.version.BloomVersion;
import com.startapp.simple.bloomfilter.version.VersionFactory;
import com.startapp.simple.bloomfilter.version.VersionFiveFactory;
import com.startapp.simple.bloomfilter.version.VersionFourFactory;
import com.startapp.simple.bloomfilter.version.VersionThreeFactory;
import com.startapp.simple.bloomfilter.version.VersionZeroFactory;
import java.util.HashMap;
import java.util.Map;

public class VersionFactoryHolder {
    private final Map<BloomVersion, VersionFactory> factories = new HashMap<BloomVersion, VersionFactory>();

    public VersionFactoryHolder() {
        this.factories.put(BloomVersion.ZERO, new VersionZeroFactory());
        this.factories.put(BloomVersion.THREE, new VersionThreeFactory());
        this.factories.put(BloomVersion.FOUR, new VersionFourFactory());
        this.factories.put(BloomVersion.FIVE, new VersionFiveFactory());
    }

    public BitSetHandling getBitSetHandling(BloomVersion bloomVersion) {
        return this.factories.get((Object)bloomVersion).getBitSetHandling();
    }

    public TokenCompression getTokenCompression(BloomVersion bloomVersion) {
        return this.factories.get((Object)bloomVersion).getTokenCompression();
    }

    public TokenToBitSet getTokenToBitSet(BloomVersion bloomVersion) {
        return this.factories.get((Object)bloomVersion).getTokenToBitSet();
    }

    public BloomVersion getBloomVersion(BloomVersion bloomVersion) {
        return this.factories.get((Object)bloomVersion).getBloomVersion();
    }
}

