/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.ads.banner;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.startapp.sdk.ads.banner.BannerMetaData;
import com.startapp.sdk.ads.banner.BannerOptions;
import com.startapp.sdk.ads.banner.a;
import com.startapp.sdk.ads.banner.b;
import com.startapp.sdk.adsbase.adrules.AdRulesResult;
import com.startapp.sdk.adsbase.adrules.AdaptMetaData;
import com.startapp.sdk.adsbase.cache.CacheMetaData;
import com.startapp.sdk.adsbase.model.AdPreferences;
import com.startapp.sdk.adsbase.remoteconfig.MetaData;
import com.startapp.sdk.internal.ak;
import com.startapp.sdk.internal.ei;
import com.startapp.sdk.internal.g1;
import com.startapp.sdk.internal.i0;
import com.startapp.sdk.internal.nf;
import com.startapp.sdk.internal.q0;
import com.startapp.sdk.internal.s;
import com.startapp.sdk.internal.t;
import com.startapp.sdk.internal.vf;
import java.io.Serializable;

public abstract class BannerBase
extends RelativeLayout {
    private static final String LOG_TAG = "BannerBase";
    private static final int LOAD_BANNER = 1;
    private static final int LOAD_BANNER_DELAYED = 2;
    private boolean attachedToWindow;
    @Nullable
    private AdPreferences adPreferences;
    protected AdRulesResult adRulesResult;
    protected int offset;
    private boolean firstLoad;
    @Nullable
    protected Point desirableSizeForManualLoading;
    protected boolean drawn;
    protected ak viewabilityRunner;
    private boolean clicked;
    private boolean shouldReloadBanner;
    @Nullable
    private String error;
    @NonNull
    private final Runnable task;
    @NonNull
    private final Handler handler;
    @NonNull
    private final Object handlerLock;

    /*
     * WARNING - void declaration
     */
    public BannerBase(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.attachedToWindow = false;
        this.offset = 0;
        this.firstLoad = true;
        this.drawn = false;
        this.clicked = false;
        this.shouldReloadBanner = false;
        this.task = new a(this);
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new b(this));
        this.handlerLock = new Object();
        try {
            ((nf)com.startapp.sdk.components.a.a((Context)context).t.a()).a(512);
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - void declaration
     */
    public BannerBase(Context context, AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BannerBase(Context context, AttributeSet attrs, int defStyle) {
        void var3_3;
        void var2_2;
        void var1_1;
        BannerBase bannerBase = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        bannerBase.attachedToWindow = false;
        bannerBase.offset = 0;
        bannerBase.firstLoad = true;
        bannerBase.drawn = false;
        bannerBase.clicked = false;
        bannerBase.shouldReloadBanner = false;
        bannerBase.task = new a(this);
        bannerBase.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new b(this));
        bannerBase.handlerLock = new Object();
        bannerBase.setAdTag(new g1((Context)var1_1, (AttributeSet)var2_2).a);
    }

    protected void init() {
        if (!this_.isInEditMode()) {
            this_.initRuntime();
        } else {
            RelativeLayout.LayoutParams layoutParams;
            BannerBase bannerBase = this_;
            bannerBase.setMinimumWidth(ei.a(bannerBase.getContext(), this_.getWidthInDp()));
            bannerBase.setMinimumHeight(ei.a(bannerBase.getContext(), this_.getHeightInDp()));
            bannerBase.setBackgroundColor(Color.rgb((int)169, (int)169, (int)169));
            TextView textView = new TextView(this_.getContext());
            textView.setText((CharSequence)this_.getBannerName());
            textView.setTextColor(-16777216);
            BannerBase this_ = layoutParams;
            new RelativeLayout.LayoutParams(-2, -2).addRule(13);
            bannerBase.addView((View)textView, (ViewGroup.LayoutParams)this_);
        }
    }

    protected abstract void initRuntime();

    @Keep
    protected abstract int getWidthInDp();

    @Keep
    protected abstract int getHeightInDp();

    protected abstract String getBannerName();

    protected abstract void reload();

    protected abstract int getRefreshRate();

    /*
     * WARNING - void declaration
     */
    public void setAdTag(@Nullable String adTag) {
        void var1_1;
        this.getAdPreferences().setAdTag((String)var1_1);
    }

    protected int getAdjustedRefreshRate() {
        return this.getRefreshRate();
    }

    protected abstract void hideBanner();

    @Nullable
    protected String getAdTag() {
        return this.getAdPreferences().getAdTag();
    }

    /*
     * WARNING - void declaration
     */
    public void loadAd(int desirableWidthDp, int desirableHeightDp) {
        void var2_2;
        void var1_1;
        Point point;
        if (this_.getParent() != null) {
            return;
        }
        try {
            ((nf)com.startapp.sdk.components.a.a((Context)this_.getContext()).t.a()).a(1024);
        }
        catch (Throwable throwable) {}
        BannerBase bannerBase = this_;
        BannerBase this_ = point;
        point = new Point((int)var1_1, (int)var2_2);
        bannerBase.desirableSizeForManualLoading = this_;
        bannerBase.loadBanner();
    }

    public void loadAd() {
        BannerBase bannerBase = this;
        DisplayMetrics displayMetrics = bannerBase.getContext().getResources().getDisplayMetrics();
        bannerBase.loadAd(ei.b(bannerBase.getContext(), displayMetrics.widthPixels), ei.b(this.getContext(), displayMetrics.heightPixels));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadBanner() {
        BannerBase bannerBase = this;
        Object object = bannerBase.handlerLock;
        synchronized (object) {
            Throwable throwable2;
            block5: {
                try {
                    if (!bannerBase.handler.hasMessages(1)) {
                        this.handler.sendEmptyMessage(1);
                    }
                }
                catch (Throwable throwable2) {
                    break block5;
                }
                return;
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void loadBannerDelayed(long delay) {
        Object object = this.handlerLock;
        BannerBase bannerBase = this;
        synchronized (object) {
            void var1_1;
            bannerBase.handler.removeMessages(2);
            bannerBase.handler.sendEmptyMessageDelayed(2, (long)var1_1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelDelayedLoading() {
        Object object = this.handlerLock;
        synchronized (object) {
            this.handler.removeMessages(2);
            return;
        }
    }

    protected void loadBannerImpl() {
        BannerBase bannerBase = this;
        bannerBase.scheduleReloadTask();
        bannerBase.load();
    }

    protected void load() {
        Object object = this.viewabilityRunner;
        if (object != null) {
            ((ak)object).a();
            this.viewabilityRunner = null;
        }
        if (this.adRulesResult != null && !AdaptMetaData.b().a().b()) {
            if (this.adRulesResult.b()) {
                this.reload();
            }
        } else {
            object = AdPreferences.Placement.INAPP_BANNER;
            object = AdaptMetaData.b().a().a((AdPreferences.Placement)((Object)object), this.getAdTag());
            this.adRulesResult = object;
            if (((AdRulesResult)object).b()) {
                this.reload();
            } else {
                this.hideBanner();
            }
        }
    }

    protected boolean shouldSendImpression(vf vf2) {
        return vf2 != null && vf2.j.get() == 0;
    }

    protected void startVisibilityRunnable(vf vf2) {
        ak ak2;
        ak ak3;
        if (object.viewabilityRunner != null) {
            return;
        }
        BannerOptions bannerOptions = BannerMetaData.c().a();
        ak ak4 = ak3 = ak2;
        ak4(object.getViewableBanner(), vf2, bannerOptions);
        object.viewabilityRunner = ak4;
        Object object = ak2.f;
        if (object != null && ((vf)object).j.get() == 0 && ak3.e.get() != null) {
            ak3.run();
        }
    }

    @NonNull
    protected View getViewableBanner() {
        return this;
    }

    protected void scheduleReloadTask() {
        if (this.attachedToWindow && !this.isInEditMode()) {
            if (!CacheMetaData.d()) {
                return;
            }
            BannerBase bannerBase = this;
            bannerBase.removeCallbacks(bannerBase.task);
            bannerBase.postDelayed(bannerBase.task, this.getAdjustedRefreshRate());
            bannerBase.loadBannerDelayed(MetaData.y().H() * 1000);
            return;
        }
    }

    protected void cancelReloadTask() {
        if (!this.isInEditMode()) {
            BannerBase bannerBase = this;
            bannerBase.removeCallbacks(bannerBase.task);
            bannerBase.cancelDelayedLoading();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        Bundle bundle2;
        if (this.isClicked()) {
            this.setClicked(false);
            this.shouldReloadBanner = true;
        }
        Parcelable parcelable = super.onSaveInstanceState();
        Bundle bundle3 = bundle2 = bundle;
        bundle3();
        bundle3.putParcelable("upperState", parcelable);
        bundle2.putSerializable("adRulesResult", (Serializable)this.adRulesResult);
        bundle2.putSerializable("adPreferences", (Serializable)this.adPreferences);
        bundle2.putInt("offset", this.offset);
        bundle2.putBoolean("firstLoad", this.firstLoad);
        bundle.putBoolean("shouldReloadBanner", this.shouldReloadBanner);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle bundle;
        if (!(state instanceof Bundle)) {
            super.onRestoreInstanceState((Parcelable)bundle);
            return;
        }
        bundle = bundle;
        this.adRulesResult = (AdRulesResult)bundle.getSerializable("adRulesResult");
        this.adPreferences = (AdPreferences)bundle.getSerializable("adPreferences");
        this.offset = bundle.getInt("offset");
        this.firstLoad = bundle.getBoolean("firstLoad");
        this.shouldReloadBanner = bundle.getBoolean("shouldReloadBanner");
        super.onRestoreInstanceState(bundle.getParcelable("upperState"));
    }

    protected void onAttachedToWindow() {
        BannerBase bannerBase = this;
        super.onAttachedToWindow();
        try {
            ((nf)com.startapp.sdk.components.a.a((Context)bannerBase.getContext()).t.a()).a(4096);
        }
        catch (Throwable throwable) {}
        this.attachedToWindow = true;
        this.scheduleReloadTask();
    }

    protected void onDetachedFromWindow() {
        BannerBase bannerBase = this;
        super.onDetachedFromWindow();
        bannerBase.attachedToWindow = false;
        bannerBase.cancelReloadTask();
        ak ak2 = bannerBase.viewabilityRunner;
        if (ak2 != null) {
            ak2.a();
            this.viewabilityRunner = null;
        }
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            if (this.shouldReloadBanner) {
                this.shouldReloadBanner = false;
                this.load();
            }
            this.attachedToWindow = true;
            this.scheduleReloadTask();
        } else {
            this.attachedToWindow = false;
            this.cancelReloadTask();
        }
    }

    public boolean isFirstLoad() {
        return this.firstLoad;
    }

    /*
     * WARNING - void declaration
     */
    public void setFirstLoad(boolean firstLoad) {
        void var1_1;
        this.firstLoad = var1_1;
    }

    protected void addDisplayEventOnLoad() {
        if (this_.isFirstLoad() || AdaptMetaData.b().a().b()) {
            this_.setFirstLoad(false);
            BannerBase bannerBase = this_;
            Object this_ = AdPreferences.Placement.INAPP_BANNER;
            t.d.a(new s((AdPreferences.Placement)((Object)this_), bannerBase.getAdTag()));
        }
    }

    public boolean isClicked() {
        return this.clicked;
    }

    /*
     * WARNING - void declaration
     */
    public void setClicked(boolean clicked) {
        void var1_1;
        this.clicked = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setErrorMessage(@Nullable String error) {
        void var1_1;
        this.error = var1_1;
    }

    @Nullable
    public String getErrorMessage() {
        return this.error;
    }

    /*
     * WARNING - void declaration
     */
    public void setAdPreferences(@Nullable AdPreferences adPreferences) {
        AdPreferences adPreferences2;
        if (adPreferences != null) {
            void var1_1;
            AdPreferences adPreferences3;
            adPreferences2 = adPreferences3;
            adPreferences3 = new AdPreferences((AdPreferences)var1_1);
        } else {
            adPreferences2 = null;
        }
        this.adPreferences = adPreferences2;
    }

    @NonNull
    public AdPreferences getAdPreferences() {
        AdPreferences adPreferences = this.adPreferences;
        if (adPreferences == null) {
            AdPreferences adPreferences2;
            adPreferences = adPreferences2;
            adPreferences2 = new AdPreferences();
            this.adPreferences = adPreferences;
        }
        return adPreferences;
    }

    @NonNull
    protected AdPreferences prepareAdPreferences() {
        AdPreferences adPreferences = this.getAdPreferences();
        if (adPreferences.getPlacementId() == null) {
            adPreferences.setPlacementId(i0.a((View)this));
        }
        AdPreferences adPreferences2 = adPreferences;
        BannerBase bannerBase = this;
        adPreferences2.setHardwareAccelerated(q0.a((View)bannerBase, bannerBase.attachedToWindow));
        return adPreferences2;
    }
}

