/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.ads.video;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.startapp.json.TypeInfo;
import com.startapp.sdk.ads.video.tracking.VideoTrackingDetails;
import com.startapp.sdk.adsbase.VideoConfig;
import com.startapp.sdk.internal.pi;
import com.startapp.sdk.internal.qi;
import com.startapp.sdk.internal.wi;
import com.startapp.sdk.omsdk.VerificationDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Keep
public class VideoAdDetails
implements Serializable {
    private static final long serialVersionUID = 4938639129535870268L;
    private String videoUrl;
    private String localVideoPath;
    @TypeInfo(type=PostRollType.class)
    private PostRollType postRoll;
    private String postRollHtml;
    private String postRollClickThroughUrl;
    private boolean closeable;
    private boolean skippable;
    private long skippableAfter;
    private boolean clickable;
    private boolean isVideoMuted;
    private String clickUrl;
    @Nullable
    private Long unskipLess;
    @TypeInfo(complex=true)
    private VideoTrackingDetails videoTrackingDetails;
    @TypeInfo(type=ArrayList.class, value=VerificationDetails.class)
    @Nullable
    private List<VerificationDetails> adVerifications;

    @Keep
    public VideoAdDetails() {
    }

    public VideoAdDetails(@NonNull qi qi2, @NonNull VideoConfig videoConfig, @Nullable wi wi2) {
        this.videoTrackingDetails = new VideoTrackingDetails(qi2);
        this.videoUrl = qi2.p;
        if (wi2 != null) {
            Long l10 = wi2.a;
            Integer n10 = qi2.m;
            long l11 = l10 != null ? l10 : (n10 != null ? (long)n10.intValue() : videoConfig.n());
            VideoAdDetails videoAdDetails = this;
            videoAdDetails.skippableAfter = l11;
            videoAdDetails.skippable = true;
            this.unskipLess = wi2.b;
        } else {
            this.skippable = false;
        }
        this.clickUrl = qi2.s;
        boolean bl = this.clickUrl != null;
        VideoAdDetails videoAdDetails = this;
        videoAdDetails.clickable = bl;
        videoAdDetails.postRoll = PostRollType.NONE;
        pi pi2 = qi2.o;
        if (pi2 != null) {
            this.postRollHtml = pi2.c.a();
            this.postRollClickThroughUrl = pi2.d;
        }
        this.setAdVerifications(Collections.unmodifiableList(qi2.t));
    }

    public void setup() {
        this.skippableAfter = TimeUnit.SECONDS.toMillis(this.skippableAfter);
    }

    public String getVideoUrl() {
        return this.videoUrl;
    }

    public String getLocalVideoPath() {
        return this.localVideoPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setLocalVideoPath(String localVideoPath) {
        void var1_1;
        this.localVideoPath = var1_1;
    }

    public PostRollType getPostRollType() {
        return this.postRoll;
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public boolean isSkippable() {
        return this.skippable;
    }

    public long getSkippableAfter() {
        return this.skippableAfter;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    @Nullable
    public Long getUnskipLess() {
        return this.unskipLess;
    }

    public VideoTrackingDetails getVideoTrackingDetails() {
        return this.videoTrackingDetails;
    }

    public boolean isVideoMuted() {
        return this.isVideoMuted;
    }

    /*
     * WARNING - void declaration
     */
    public void setVideoMuted(boolean isVideoMuted) {
        void var1_1;
        this.isVideoMuted = var1_1;
    }

    public String getClickUrl() {
        return this.clickUrl;
    }

    public String getPostRollClickThroughUrl() {
        return this.postRollHtml != null ? this.postRollClickThroughUrl : this.clickUrl;
    }

    @Nullable
    public String getPostRollHtml() {
        return this.postRollHtml;
    }

    public boolean hasPostRoll() {
        return this.postRoll != PostRollType.NONE || this.postRollHtml != null;
    }

    @Nullable
    public List<VerificationDetails> getAdVerifications() {
        return this.adVerifications;
    }

    /*
     * WARNING - void declaration
     */
    public void setAdVerifications(@Nullable List<VerificationDetails> adVerifications) {
        void var1_1;
        this.adVerifications = var1_1;
    }

    @NonNull
    public String toString() {
        return super.toString();
    }

    @Keep
    public static enum PostRollType {
        IMAGE,
        LAST_FRAME,
        NONE;

    }
}

