/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.adsbase;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.startapp.sdk.adsbase.ActivityExtra;
import com.startapp.sdk.adsbase.a;
import com.startapp.sdk.adsbase.adinformation.AdInformationOverrides;
import com.startapp.sdk.adsbase.adlisteners.AdEventListener;
import com.startapp.sdk.adsbase.adlisteners.NotDisplayedReason;
import com.startapp.sdk.adsbase.b;
import com.startapp.sdk.adsbase.cache.CacheMetaData;
import com.startapp.sdk.adsbase.consent.ConsentData;
import com.startapp.sdk.adsbase.f;
import com.startapp.sdk.adsbase.model.AdPreferences;
import com.startapp.sdk.adsbase.remoteconfig.MetaData;
import com.startapp.sdk.internal.b0;
import com.startapp.sdk.internal.i0;
import com.startapp.sdk.internal.kg;
import com.startapp.sdk.internal.p6;
import java.io.Serializable;

public abstract class Ad
implements Serializable {
    private static final long serialVersionUID = -9152265423662238762L;
    private static boolean init = false;
    @NonNull
    protected transient Context context;
    protected ActivityExtra activityExtra;
    protected Serializable extraData;
    private AdInformationOverrides adInfoOverride;
    protected AdPreferences.Placement placement;
    protected ConsentData consentData;
    @Nullable
    protected String errorMessage;
    protected Long adCacheTtl;
    private AdState state;
    private NotDisplayedReason notDisplayedReason;
    private Long lastLoadTime;
    private AdType type;
    protected boolean belowMinCPM;
    private boolean videoCancelCallBack;
    @Nullable
    private String requestUrl;

    /*
     * WARNING - void declaration
     */
    @Keep
    public Ad(@NonNull Context context, AdPreferences.Placement placement) {
        void var2_2;
        void var1_1;
        Ad ad2 = this;
        this.extraData = null;
        this.adCacheTtl = null;
        this.state = AdState.UN_INITIALIZED;
        this.lastLoadTime = null;
        this.belowMinCPM = false;
        this.context = var1_1;
        ad2.placement = var2_2;
        ad2.adInfoOverride = AdInformationOverrides.a();
    }

    /*
     * WARNING - void declaration
     */
    static void access$000(Ad x02, Long x12) {
        void var1_1;
        x02.lastLoadTime = var1_1;
    }

    @Keep
    public Serializable getExtraData() {
        return this.extraData;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(@NonNull Context context) {
        void var1_1;
        this.context = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setActivityExtra(ActivityExtra activityExtra) {
        void var1_1;
        this.activityExtra = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setExtraData(Serializable extraData) {
        void var1_1;
        this.extraData = var1_1;
    }

    @Keep
    public AdState getState() {
        return this.state;
    }

    @Keep
    public boolean isBelowMinCPM() {
        return this.belowMinCPM;
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setState(AdState state) {
        void var1_1;
        this.state = var1_1;
    }

    @Keep
    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setErrorMessage(@Nullable String errorMessage) {
        void var1_1;
        this.errorMessage = var1_1;
    }

    @Keep
    public AdInformationOverrides getAdInfoOverride() {
        return this.adInfoOverride;
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setAdInfoOverride(AdInformationOverrides adInfoOverride) {
        void var1_1;
        this.adInfoOverride = var1_1;
    }

    @Keep
    @Nullable
    public final ConsentData getConsentData() {
        return this.consentData;
    }

    protected AdPreferences.Placement getPlacement() {
        return this.placement;
    }

    /*
     * WARNING - void declaration
     */
    protected void setPlacement(AdPreferences.Placement mode) {
        void var1_1;
        this.placement = var1_1;
    }

    @Deprecated
    @Keep
    public void load() {
        AdPreferences adPreferences;
        Ad ad2 = this_;
        Serializable this_ = adPreferences;
        adPreferences = new AdPreferences();
        ad2.load((AdPreferences)this_, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Keep
    public void load(AdEventListener callback) {
        void var1_1;
        AdPreferences adPreferences;
        Ad ad2 = this_;
        Serializable this_ = adPreferences;
        adPreferences = new AdPreferences();
        ad2.load((AdPreferences)this_, (AdEventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Keep
    public void load(AdPreferences adPreferences) {
        void var1_1;
        this.load((AdPreferences)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Keep
    public void load(AdPreferences adPreferences, AdEventListener callback) {
        void var2_2;
        void var1_1;
        this.load((AdPreferences)var1_1, (AdEventListener)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public boolean load(AdPreferences adPreferences, AdEventListener listener, boolean waitForMetadata) {
        void var3_5;
        void var1_1;
        b b10;
        void var2_2;
        a a10;
        Object object = a10;
        a10 = new a(this, (AdEventListener)var2_2);
        if (!init) {
            f.f(this.context);
            init = true;
        }
        boolean bl = false;
        String string = "";
        if (this.state != AdState.UN_INITIALIZED) {
            bl = true;
            string = "load() was already called.";
        }
        if (!((p6)com.startapp.sdk.components.a.a((Context)this.context).s.a()).b()) {
            bl = true;
            string = "network not available.";
        }
        if (!this.canShowAd()) {
            bl = true;
            string = "serving ads disabled";
        }
        if (bl) {
            Ad ad2 = this;
            ad2.setErrorMessage("Ad wasn't loaded: ".concat(string));
            b0.a(ad2.context, (AdEventListener)object, this, false);
            return false;
        }
        this.setState(AdState.PROCESSING);
        b b11 = b10;
        b10 = new b(this, (AdPreferences)var1_1, (a)object);
        if (var1_1.getType() != null) {
            this.type = var1_1.getType();
        }
        if (var1_1.getPlacementId() == null) {
            String string2;
            block9: {
                Ad ad3 = this;
                object = ad3.context;
                string = object.getPackageName();
                string2 = ad3.getClass().getName();
                while (object instanceof ContextWrapper) {
                    if (object instanceof Activity) {
                        object = object.getClass().getName();
                        break block9;
                    }
                    object = ((ContextWrapper)object).getBaseContext();
                }
                object = null;
            }
            var1_1.setPlacementId(i0.a(string, string2, (String)object, null));
        }
        MetaData.y().a(this.context, (AdPreferences)var1_1, kg.d.c, (boolean)var3_5, b11, false);
        return true;
    }

    protected abstract void loadAds(AdPreferences var1, AdEventListener var2);

    @Keep
    public boolean isReady() {
        return this.state == AdState.READY && !this.hasAdCacheTtlPassed();
    }

    @Keep
    public NotDisplayedReason getNotDisplayedReason() {
        return this.notDisplayedReason;
    }

    /*
     * WARNING - void declaration
     */
    protected void setNotDisplayedReason(NotDisplayedReason reason) {
        void var1_1;
        this.notDisplayedReason = var1_1;
    }

    protected Long getAdCacheTtl() {
        Ad ad2 = this_;
        long l10 = ad2.getFallbackAdCacheTtl();
        Serializable this_ = ad2.adCacheTtl;
        if (this_ != null) {
            l10 = Math.min((Long)this_, l10);
        }
        return l10;
    }

    protected long getFallbackAdCacheTtl() {
        return CacheMetaData.b().a().a();
    }

    protected Long getLastLoadTime() {
        return this.lastLoadTime;
    }

    protected boolean hasAdCacheTtlPassed() {
        if (this.lastLoadTime == null) {
            return false;
        }
        return System.currentTimeMillis() - this.lastLoadTime > this.getAdCacheTtl();
    }

    @Keep
    public AdType getType() {
        return this.type;
    }

    protected boolean getVideoCancelCallBack() {
        return this.videoCancelCallBack;
    }

    /*
     * WARNING - void declaration
     */
    protected void setVideoCancelCallBack(boolean videoCancelCallBack) {
        void var1_1;
        this.videoCancelCallBack = var1_1;
    }

    protected boolean canShowAd() {
        return MetaData.y().b();
    }

    @Nullable
    public String getRequestUrl() {
        return this.requestUrl;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestUrl(@Nullable String requestUrl) {
        void var1_1;
        this.requestUrl = var1_1;
    }

    @Nullable
    public String getDParam() {
        return null;
    }

    public abstract String getAdId();

    @Keep
    public static enum AdState {
        UN_INITIALIZED,
        PROCESSING,
        READY;

    }

    @Keep
    public static enum AdType {
        INTERSTITIAL,
        RICH_TEXT,
        VIDEO,
        REWARDED_VIDEO,
        NON_VIDEO,
        VIDEO_NO_VAST;

    }
}

