/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.adsbase.adinformation;

import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.startapp.json.TypeInfo;
import com.startapp.sdk.adsbase.adinformation.AdInformationPositions;
import com.startapp.sdk.adsbase.adinformation.ImageResourceConfig;
import com.startapp.sdk.adsbase.model.AdPreferences;
import com.startapp.sdk.components.a;
import com.startapp.sdk.internal.m2;
import com.startapp.sdk.internal.oi;
import com.startapp.sdk.internal.pf;
import com.startapp.sdk.internal.qf;
import com.startapp.sdk.internal.t8;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

@Keep
public class AdInformationConfig
implements Serializable {
    private static final long serialVersionUID = 8911501868319500986L;
    protected static final boolean DEFAULT_EANBLED = true;
    private static final float DEFAULT_FAT_FINGERS_FACTOR = 200.0f;
    private static final String DEFAULT_DIALOG_URL;
    private static final String DEFAULT_EULA_URL = "https://www.startapp.com/policy/privacy-policy/";
    private boolean enabled = true;
    private float fatFingersFactor = 200.0f;
    private String dialogUrlSecured = DEFAULT_DIALOG_URL;
    private String eulaUrlSecured = "https://www.startapp.com/policy/privacy-policy/";
    @Nullable
    private Integer consentTypeInfo;
    @TypeInfo(type=HashMap.class, key=AdPreferences.Placement.class, value=AdInformationPositions.Position.class)
    protected HashMap<AdPreferences.Placement, AdInformationPositions.Position> Positions = new HashMap();
    private transient EnumMap<ImageResourceType, ImageResourceConfig> imageResources = new EnumMap(ImageResourceType.class);
    @TypeInfo(type=ArrayList.class, value=ImageResourceConfig.class)
    private List<ImageResourceConfig> ImageResources = new ArrayList<ImageResourceConfig>();

    @Keep
    private AdInformationConfig() {
    }

    @Keep
    public static AdInformationConfig createAdInformationConfig() {
        AdInformationConfig adInformationConfig = new AdInformationConfig();
        AdInformationConfig.setDefaultValues(adInformationConfig);
        return adInformationConfig;
    }

    @Keep
    public static void setDefaultValues(AdInformationConfig adInformationConfig) {
        AdInformationConfig adInformationConfig2 = adInformationConfig;
        adInformationConfig2.updateFallbackImageResources();
        adInformationConfig2.validateImageResourcesConfig();
    }

    static {
        byte[] byArray = new byte[60];
        byte[] byArray2 = byArray;
        byArray[0] = 104;
        byArray2[1] = 116;
        byArray2[2] = 116;
        byArray2[3] = 112;
        byArray2[4] = 115;
        byArray2[5] = 58;
        byArray2[6] = 47;
        byArray2[7] = 47;
        byArray2[8] = 102;
        byArray2[9] = 117;
        byArray2[10] = 110;
        byArray2[11] = 110;
        byArray2[12] = 101;
        byArray2[13] = 108;
        byArray2[14] = 45;
        byArray2[15] = 97;
        byArray2[16] = 115;
        byArray2[17] = 115;
        byArray2[18] = 101;
        byArray2[19] = 116;
        byArray2[20] = 115;
        byArray2[21] = 46;
        byArray2[22] = 115;
        byArray2[23] = 116;
        byArray2[24] = 97;
        byArray2[25] = 114;
        byArray2[26] = 116;
        byArray2[27] = 97;
        byArray2[28] = 112;
        byArray2[29] = 112;
        byArray2[30] = 115;
        byArray2[31] = 101;
        byArray2[32] = 114;
        byArray2[33] = 118;
        byArray2[34] = 105;
        byArray2[35] = 99;
        byArray2[36] = 101;
        byArray2[37] = 46;
        byArray2[38] = 99;
        byArray2[39] = 111;
        byArray2[40] = 109;
        byArray2[41] = 47;
        byArray2[42] = 99;
        byArray2[43] = 111;
        byArray2[44] = 110;
        byArray2[45] = 115;
        byArray2[46] = 101;
        byArray2[47] = 110;
        byArray2[48] = 116;
        byArray2[49] = 47;
        byArray2[50] = 105;
        byArray2[51] = 110;
        byArray2[52] = 100;
        byArray2[53] = 101;
        byArray2[54] = 120;
        byArray2[55] = 46;
        byArray2[56] = 104;
        byArray2[57] = 116;
        byArray2[58] = 109;
        byArray2[59] = 108;
        DEFAULT_DIALOG_URL = new String(byArray2);
    }

    @Keep
    @Nullable
    public Integer getConsentTypeInfo() {
        return this.consentTypeInfo;
    }

    @Keep
    public String getEulaUrl() {
        String string = this.eulaUrlSecured;
        if (string != null && !string.equals("")) {
            return this.eulaUrlSecured;
        }
        return DEFAULT_EULA_URL;
    }

    @Keep
    public String getPrivacyIconImageUrl() {
        ImageResourceType imageResourceType = ImageResourceType.INFO_L;
        if (this.imageResources.containsKey((Object)imageResourceType) && !this.imageResources.get((Object)imageResourceType).b().equals("")) {
            return this.imageResources.get((Object)imageResourceType).b();
        }
        return "https://info.startappservice.com/InApp/resources/info_l.png";
    }

    @Keep
    public boolean isMetaDataEnabled() {
        return this.enabled;
    }

    @Keep
    public boolean isEnabled(Context context) {
        return !((qf)a.a((Context)context).E.a()).getBoolean("userDisabledAdInformation", false) && this.isMetaDataEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setUserEnabled(Context context, boolean enabled) {
        void var2_3;
        pf pf2 = ((qf)a.a((Context)context).E.a()).a();
        String string = "userDisabledAdInformation";
        boolean bl = var2_3 ^ 1;
        pf2.a(string, bl);
        pf2.a.putBoolean(string, bl);
        pf2.apply();
    }

    @Keep
    public float getFatFingerFactor() {
        return this.fatFingersFactor / 100.0f;
    }

    /*
     * WARNING - void declaration
     */
    protected void setImageResourceConfig(ImageResourceType type, ImageResourceConfig imageResourceConfig) {
        void var2_2;
        void var1_1;
        this.getImageResources().put((ImageResourceType)var1_1, (ImageResourceConfig)var2_2);
    }

    @Keep
    @NonNull
    public String getDialogUrl() {
        Object this_ = ((AdInformationConfig)this_).dialogUrlSecured;
        if (this_ == null) {
            this_ = DEFAULT_DIALOG_URL;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public AdInformationPositions.Position getPosition(AdPreferences.Placement placement) {
        void var1_1;
        AdInformationPositions.Position position = this.Positions.get(var1_1);
        if (position == null) {
            position = AdInformationPositions.Position.BOTTOM_LEFT;
            this.Positions.put((AdPreferences.Placement)var1_1, position);
        }
        return position;
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public ImageResourceConfig getImageResourceConfig(ImageResourceType type) {
        void var1_1;
        return this.getImageResources().get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void initImageResourceConfigBitmaps(@NonNull Context context) {
        for (ImageResourceConfig imageResourceConfig : this.ImageResources) {
            void var1_1;
            t8 t82;
            this.setImageResourceConfig(ImageResourceType.getByName(imageResourceConfig.c()), imageResourceConfig);
            var2_2.next().a = null;
            String string = imageResourceConfig.b();
            t8 t83 = t82;
            t82 = new t8(imageResourceConfig);
            new m2((Context)var1_1, string, t83, 0).a();
        }
    }

    protected void validateImageResourcesConfig() {
        for (ImageResourceType imageResourceType : ImageResourceType.values()) {
            if (this.getImageResources().get((Object)imageResourceType) != null) {
                continue;
            }
            throw new IllegalArgumentException(String.valueOf((Object)imageResourceType));
        }
    }

    protected void updateFallbackImageResources() {
        for (ImageResourceType imageResourceType : ImageResourceType.values()) {
            ImageResourceConfig imageResourceConfig = this.getImageResources().get((Object)imageResourceType);
            boolean bl = true;
            if (imageResourceConfig == null) {
                imageResourceConfig = ImageResourceConfig.a(imageResourceType.name());
                Iterator<ImageResourceConfig> iterator = this.ImageResources.iterator();
                while (iterator.hasNext()) {
                    if (!((Object)((Object)ImageResourceType.getByName(iterator.next().c()))).equals((Object)imageResourceType)) continue;
                    bl = false;
                    break;
                }
                this.getImageResources().put(imageResourceType, imageResourceConfig);
                if (bl) {
                    this.ImageResources.add(imageResourceConfig);
                }
            }
            ImageResourceConfig imageResourceConfig2 = imageResourceConfig;
            imageResourceConfig.b(imageResourceType.getDefaultWidth());
            imageResourceConfig2.a(imageResourceType.getDefaultHeight());
            imageResourceConfig2.b(imageResourceType.name().toLowerCase(Locale.ROOT) + ".png");
        }
    }

    @Keep
    public EnumMap<ImageResourceType, ImageResourceConfig> getImageResources() {
        return this.imageResources;
    }

    @Keep
    public void initTransientFields() {
        EnumMap enumMap;
        AdInformationConfig adInformationConfig = this_;
        Serializable this_ = enumMap;
        enumMap = new EnumMap(ImageResourceType.class);
        adInformationConfig.imageResources = this_;
    }

    public boolean equals(Object o10) {
        AdInformationConfig adInformationConfig;
        if (this == adInformationConfig) {
            return true;
        }
        if (adInformationConfig != null && this.getClass() == adInformationConfig.getClass()) {
            adInformationConfig = adInformationConfig;
            return this.enabled == adInformationConfig.enabled && Float.compare(adInformationConfig.fatFingersFactor, this.fatFingersFactor) == 0 && oi.a((Object)this.consentTypeInfo, (Object)adInformationConfig.consentTypeInfo) && oi.a((Object)this.dialogUrlSecured, (Object)adInformationConfig.dialogUrlSecured) && oi.a((Object)this.eulaUrlSecured, (Object)adInformationConfig.eulaUrlSecured) && oi.a(this.Positions, adInformationConfig.Positions) && oi.a(this.ImageResources, adInformationConfig.ImageResources);
        }
        return false;
    }

    public int hashCode() {
        AdInformationConfig adInformationConfig = this_;
        Serializable this_ = Boolean.valueOf(adInformationConfig.enabled);
        Integer n10 = adInformationConfig.consentTypeInfo;
        Float f10 = Float.valueOf(adInformationConfig.fatFingersFactor);
        String string = adInformationConfig.dialogUrlSecured;
        String string2 = adInformationConfig.eulaUrlSecured;
        HashMap<AdPreferences.Placement, AdInformationPositions.Position> hashMap = adInformationConfig.Positions;
        List<ImageResourceConfig> list = adInformationConfig.ImageResources;
        return Arrays.deepHashCode(new Object[]{this_, n10, f10, string, string2, hashMap, list});
    }

    @Keep
    public static enum ImageResourceType {
        INFO_S(17, 14),
        INFO_EX_S(88, 14),
        INFO_L(25, 21),
        INFO_EX_L(130, 21);

        private final int width;
        private final int height;

        /*
         * WARNING - void declaration
         */
        private ImageResourceType(int width, int height) {
            void var4_4;
            void var3_3;
            this.width = var3_3;
            this.height = var4_4;
        }

        public static ImageResourceType getByName(String name) {
            ImageResourceType imageResourceType = INFO_S;
            for (ImageResourceType imageResourceType2 : ImageResourceType.values()) {
                String string;
                Locale locale = Locale.ROOT;
                if (imageResourceType2.name().toLowerCase(locale).compareTo(string.toLowerCase(locale)) != 0) continue;
                imageResourceType = imageResourceType2;
            }
            return imageResourceType;
        }

        public int getDefaultWidth() {
            return this.width;
        }

        public int getDefaultHeight() {
            return this.height;
        }
    }
}

