package com.startapp.json;

import static com.startapp.json.JsonUtils.getRealFieldName;
import static com.startapp.json.JsonUtils.isArray;
import static com.startapp.json.JsonUtils.isComplex;
import static com.startapp.json.JsonUtils.isList;
import static com.startapp.json.JsonUtils.isMap;
import static com.startapp.json.JsonUtils.isPrimitive;
import static com.startapp.json.JsonUtils.isSet;
import static com.startapp.json.JsonUtils.readObject;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Contains static methods to parse and to serialize objects.
 *
 * @see TypeInfo
 * @see TypeClassInfo
 * @see TypeParser
 */
@Keep
public class JsonParser {
    /**
     * Parses the JSON string as the instance of <code>classType</code>.
     * <p>
     * Never throws.
     *
     * @param json      json
     * @param classType class
     * @param <T>       target type
     * @return new instance or <code>null</code> in case of errors
     */
    @Keep
    @Nullable
    public static <T> T fromJson(@NonNull String json, @NonNull Class<T> classType) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Parses the {@link JSONObject} as the instance of <code>classType</code>.
     * <p>
     * Never throws.
     *
     * @param json      json
     * @param classType class
     * @param <T>       target type
     * @return new instance or <code>null</code> in case of errors
     */
    @Keep
    @Nullable
    public static <T> T fromJsonObject(@NonNull JSONObject json, @NonNull Class<T> classType) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Serialize object to a JSON string.
     *
     * @param object object
     * @return single-line string
     */
    @Keep
    @NonNull
    public static String toJson(@Nullable Object object) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Serialize object to a {@link JSONObject}.
     *
     * @param object object
     * @return new instance or null
     */
    @Keep
    @Nullable
    public static JSONObject toJsonObject(@Nullable Object object) {
        throw new RuntimeException("Stub!");
    }

}
