/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.analytics;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.analytics.LinkEventsReporter;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/link/analytics/LinkAnalyticsHelper;", "", "linkEventsReporter", "Lcom/stripe/android/link/analytics/LinkEventsReporter;", "(Lcom/stripe/android/link/analytics/LinkEventsReporter;)V", "onLinkLaunched", "", "onLinkPopupSkipped", "onLinkResult", "linkActivityResult", "Lcom/stripe/android/link/LinkActivityResult;", "link_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class LinkAnalyticsHelper {
    @NotNull
    private final LinkEventsReporter linkEventsReporter;
    public static final int $stable = 8;

    @Inject
    public LinkAnalyticsHelper(@NotNull LinkEventsReporter linkEventsReporter) {
        Intrinsics.checkNotNullParameter((Object)linkEventsReporter, (String)"linkEventsReporter");
        this.linkEventsReporter = linkEventsReporter;
    }

    public final void onLinkLaunched() {
        this.linkEventsReporter.onPopupShow();
    }

    public final void onLinkResult(@NotNull LinkActivityResult linkActivityResult) {
        Intrinsics.checkNotNullParameter((Object)linkActivityResult, (String)"linkActivityResult");
        LinkActivityResult linkActivityResult2 = linkActivityResult;
        if (linkActivityResult2 instanceof LinkActivityResult.Canceled) {
            switch (WhenMappings.$EnumSwitchMapping$0[((LinkActivityResult.Canceled)linkActivityResult).getReason().ordinal()]) {
                case 1: {
                    this.linkEventsReporter.onPopupCancel();
                    break;
                }
                case 2: {
                    this.linkEventsReporter.onPopupLogout();
                }
            }
        } else if (linkActivityResult2 instanceof LinkActivityResult.Completed) {
            this.linkEventsReporter.onPopupSuccess();
        } else if (linkActivityResult2 instanceof LinkActivityResult.Failed) {
            this.linkEventsReporter.onPopupError(((LinkActivityResult.Failed)linkActivityResult).getError());
        }
    }

    public final void onLinkPopupSkipped() {
        this.linkEventsReporter.onPopupSkipped();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LinkActivityResult.Canceled.Reason.values().length];
            try {
                nArray[LinkActivityResult.Canceled.Reason.BackPressed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinkActivityResult.Canceled.Reason.LoggedOut.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

