/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.elements;

import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.VisualTransformation;
import com.stripe.android.uicore.R;
import com.stripe.android.uicore.elements.FieldError;
import com.stripe.android.uicore.elements.PostalCodeVisualTransformation;
import com.stripe.android.uicore.elements.TextFieldConfig;
import com.stripe.android.uicore.elements.TextFieldIcon;
import com.stripe.android.uicore.elements.TextFieldState;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001+B)\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\bH\u0016J\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0016R\u001c\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0016\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006,"}, d2={"Lcom/stripe/android/uicore/elements/PostalCodeConfig;", "Lcom/stripe/android/uicore/elements/TextFieldConfig;", "label", "", "trailingIcon", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/uicore/elements/TextFieldIcon;", "country", "", "(ILkotlinx/coroutines/flow/MutableStateFlow;Ljava/lang/String;)V", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "getDebugLabel", "()Ljava/lang/String;", "format", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboard-PjHm6EE", "getLabel", "()Ljava/lang/Integer;", "loading", "", "getLoading", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "getTrailingIcon", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "()Landroidx/compose/ui/text/input/VisualTransformation;", "convertFromRaw", "rawValue", "convertToRaw", "displayName", "determineState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "input", "filter", "userTyped", "CountryPostalFormat", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPostalCodeConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostalCodeConfig.kt\ncom/stripe/android/uicore/elements/PostalCodeConfig\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,129:1\n429#2:130\n502#2,5:131\n429#2:136\n502#2,5:137\n*S KotlinDebug\n*F\n+ 1 PostalCodeConfig.kt\ncom/stripe/android/uicore/elements/PostalCodeConfig\n*L\n70#1:130\n70#1:131,5\n72#1:136\n72#1:137,5\n*E\n"})
public final class PostalCodeConfig
implements TextFieldConfig {
    private final int label;
    @NotNull
    private final MutableStateFlow<TextFieldIcon> trailingIcon;
    @NotNull
    private final String country;
    @NotNull
    private final CountryPostalFormat format;
    private final int capitalization;
    private final int keyboard;
    @NotNull
    private final String debugLabel;
    @NotNull
    private final VisualTransformation visualTransformation;
    @NotNull
    private final MutableStateFlow<Boolean> loading;
    public static final int $stable = 8;

    public PostalCodeConfig(@StringRes int label, @NotNull MutableStateFlow<TextFieldIcon> trailingIcon, @NotNull String country) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(trailingIcon, (String)"trailingIcon");
        Intrinsics.checkNotNullParameter((Object)country, (String)"country");
        this.label = label;
        this.trailingIcon = trailingIcon;
        this.country = country;
        CountryPostalFormat countryPostalFormat = this.format = CountryPostalFormat.Companion.forCountry(this.country);
        if (Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.US.INSTANCE)) {
            n2 = KeyboardCapitalization.Companion.getNone-IUNYP9k();
        } else if ((Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.CA.INSTANCE) ? true : Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.GB.INSTANCE)) ? true : Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.Other.INSTANCE)) {
            n2 = KeyboardCapitalization.Companion.getCharacters-IUNYP9k();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.capitalization = n2;
        countryPostalFormat = this.format;
        if (Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.US.INSTANCE)) {
            n = KeyboardType.Companion.getNumberPassword-PjHm6EE();
        } else if ((Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.CA.INSTANCE) ? true : Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.GB.INSTANCE)) ? true : Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.Other.INSTANCE)) {
            n = KeyboardType.Companion.getText-PjHm6EE();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.keyboard = n;
        this.debugLabel = "postal_code_text";
        this.visualTransformation = new PostalCodeVisualTransformation(this.format);
        this.loading = StateFlowKt.MutableStateFlow((Object)false);
    }

    public /* synthetic */ PostalCodeConfig(int n, MutableStateFlow mutableStateFlow, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            mutableStateFlow = StateFlowKt.MutableStateFlow(null);
        }
        this(n, (MutableStateFlow<TextFieldIcon>)mutableStateFlow, string2);
    }

    @Override
    @NotNull
    public Integer getLabel() {
        return this.label;
    }

    @NotNull
    public MutableStateFlow<TextFieldIcon> getTrailingIcon() {
        return this.trailingIcon;
    }

    @Override
    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @Override
    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    @NotNull
    public VisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    @NotNull
    public MutableStateFlow<Boolean> getLoading() {
        return this.loading;
    }

    @Override
    @NotNull
    public TextFieldState determineState(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new TextFieldState(this, input){
            final /* synthetic */ PostalCodeConfig this$0;
            final /* synthetic */ String $input;
            {
                this.this$0 = $receiver;
                this.$input = $input;
            }

            public boolean shouldShowError(boolean hasFocus2) {
                return this.getError() != null && !hasFocus2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid() {
                if (PostalCodeConfig.access$getFormat$p(this.this$0) instanceof CountryPostalFormat.Other) {
                    if (StringsKt.isBlank((CharSequence)this.$input)) return false;
                    return true;
                }
                int n = PostalCodeConfig.access$getFormat$p(this.this$0).getMinimumLength();
                int n2 = PostalCodeConfig.access$getFormat$p(this.this$0).getMaximumLength();
                int n3 = this.$input.length();
                if (n > n3) return false;
                if (n3 > n2) return false;
                boolean bl = true;
                if (!bl) return false;
                CharSequence charSequence = this.$input;
                if (!PostalCodeConfig.access$getFormat$p(this.this$0).getRegexPattern().matches(charSequence)) return false;
                return true;
            }

            @Nullable
            public FieldError getError() {
                return !StringsKt.isBlank((CharSequence)this.$input) && !this.isValid() && Intrinsics.areEqual((Object)PostalCodeConfig.access$getCountry$p(this.this$0), (Object)"US") ? new FieldError(R.string.stripe_address_zip_invalid, null, 2, null) : (!StringsKt.isBlank((CharSequence)this.$input) && !this.isValid() ? new FieldError(R.string.stripe_address_zip_postal_invalid, null, 2, null) : null);
            }

            public boolean isFull() {
                return this.$input.length() >= PostalCodeConfig.access$getFormat$p(this.this$0).getMaximumLength();
            }

            public boolean isBlank() {
                return StringsKt.isBlank((CharSequence)this.$input);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String filter(@NotNull String userTyped) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        CountryPostalFormat countryPostalFormat = this.format;
        if (Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.US.INSTANCE)) {
            void $this$filterTo$iv$iv;
            String $this$filter$iv = userTyped;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!Character.isDigit(it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string3 = ((StringBuilder)destination$iv$iv).toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        } else if (Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.CA.INSTANCE) ? true : Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.GB.INSTANCE)) {
            String $this$filter$iv = userTyped;
            boolean $i$f$filter = false;
            CharSequence $this$filterTo$iv$iv = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!Character.isLetterOrDigit(it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string4 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            String string5 = string4.toUpperCase(Locale.ROOT);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
        } else if (Intrinsics.areEqual((Object)countryPostalFormat, (Object)CountryPostalFormat.Other.INSTANCE)) {
            string2 = userTyped;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return StringsKt.take((String)string2, (int)this.format.getMaximumLength());
    }

    @Override
    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        CharSequence charSequence = rawValue;
        Regex regex = new Regex("\\s+");
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    @Override
    @Nullable
    public String getPlaceHolder() {
        return TextFieldConfig.DefaultImpls.getPlaceHolder(this);
    }

    public static final /* synthetic */ CountryPostalFormat access$getFormat$p(PostalCodeConfig $this) {
        return $this.format;
    }

    public static final /* synthetic */ String access$getCountry$p(PostalCodeConfig $this) {
        return $this.country;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u000e2\u00020\u0001:\u0005\r\u000e\u000f\u0010\u0011B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0004\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;", "", "minimumLength", "", "maximumLength", "regexPattern", "Lkotlin/text/Regex;", "(IILkotlin/text/Regex;)V", "getMaximumLength", "()I", "getMinimumLength", "getRegexPattern", "()Lkotlin/text/Regex;", "CA", "Companion", "GB", "Other", "US", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat$CA;", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat$GB;", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat$Other;", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat$US;", "stripe-ui-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @StabilityInferred(parameters=0)
    public static abstract class CountryPostalFormat {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int minimumLength;
        private final int maximumLength;
        @NotNull
        private final Regex regexPattern;
        public static final int $stable = 8;

        private CountryPostalFormat(int minimumLength, int maximumLength, Regex regexPattern) {
            this.minimumLength = minimumLength;
            this.maximumLength = maximumLength;
            this.regexPattern = regexPattern;
        }

        public final int getMinimumLength() {
            return this.minimumLength;
        }

        public final int getMaximumLength() {
            return this.maximumLength;
        }

        @NotNull
        public final Regex getRegexPattern() {
            return this.regexPattern;
        }

        public /* synthetic */ CountryPostalFormat(int minimumLength, int maximumLength, Regex regexPattern, DefaultConstructorMarker $constructor_marker) {
            this(minimumLength, maximumLength, regexPattern);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat$CA;", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;", "()V", "stripe-ui-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @StabilityInferred(parameters=1)
        public static final class CA
        extends CountryPostalFormat {
            @NotNull
            public static final CA INSTANCE = new CA();
            public static final int $stable;

            private CA() {
                super(6, 6, new Regex("[a-zA-Z]\\d[a-zA-Z][\\s-]?\\d[a-zA-Z]\\d"), null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat$Companion;", "", "()V", "forCountry", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;", "country", "", "stripe-ui-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CountryPostalFormat forCountry(@NotNull String country) {
                CountryPostalFormat countryPostalFormat;
                Intrinsics.checkNotNullParameter((Object)country, (String)"country");
                switch (country) {
                    case "US": {
                        countryPostalFormat = US.INSTANCE;
                        break;
                    }
                    case "CA": {
                        countryPostalFormat = CA.INSTANCE;
                        break;
                    }
                    case "GB": {
                        countryPostalFormat = GB.INSTANCE;
                        break;
                    }
                    default: {
                        countryPostalFormat = Other.INSTANCE;
                    }
                }
                return countryPostalFormat;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat$GB;", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;", "()V", "stripe-ui-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @StabilityInferred(parameters=1)
        public static final class GB
        extends CountryPostalFormat {
            @NotNull
            public static final GB INSTANCE = new GB();
            public static final int $stable;

            private GB() {
                super(5, 7, new Regex("^[A-Za-z][A-Za-z0-9]*(?: [A-Za-z0-9]*)?$"), null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat$Other;", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;", "()V", "stripe-ui-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @StabilityInferred(parameters=1)
        public static final class Other
        extends CountryPostalFormat {
            @NotNull
            public static final Other INSTANCE = new Other();
            public static final int $stable;

            private Other() {
                super(1, Integer.MAX_VALUE, new Regex(".*"), null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat$US;", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;", "()V", "stripe-ui-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @StabilityInferred(parameters=1)
        public static final class US
        extends CountryPostalFormat {
            @NotNull
            public static final US INSTANCE = new US();
            public static final int $stable;

            private US() {
                super(5, 5, new Regex("\\d+"), null);
            }
        }
    }
}

