/*
 * blackduck-common-api
 *
 * Copyright (c) 2021 Synopsys, Inc.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.synopsys.integration.blackduck.api.generated.component;

import java.math.BigDecimal;
import com.synopsys.integration.blackduck.api.core.BlackDuckComponent;
import com.synopsys.integration.blackduck.api.generated.component.VulnerabilityCvss3TemporalMetricsView;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3AttackComplexityType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3AttackVectorType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3AvailabilityImpactType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3ConfidentialityImpactType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3IntegrityImpactType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3PrivilegesRequiredType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3ScopeType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3UserInteractionType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilitySeverityType;

// this file should not be edited - if changes are necessary, the generator should be updated, then this file should be re-created
public class VulnerabilityCvss3View extends BlackDuckComponent {
    private VulnerabilityCvss3AttackComplexityType attackComplexity;
    private VulnerabilityCvss3AttackVectorType attackVector;
    private VulnerabilityCvss3AvailabilityImpactType availabilityImpact;
    private BigDecimal baseScore;
    private VulnerabilityCvss3ConfidentialityImpactType confidentialityImpact;
    private BigDecimal exploitabilitySubscore;
    private BigDecimal impactSubscore;
    private VulnerabilityCvss3IntegrityImpactType integrityImpact;
    private VulnerabilityCvss3PrivilegesRequiredType privilegesRequired;
    private VulnerabilityCvss3ScopeType scope;
    private VulnerabilitySeverityType severity;
    private VulnerabilityCvss3TemporalMetricsView temporalMetrics;
    private VulnerabilityCvss3UserInteractionType userInteraction;
    private String vector;

    public VulnerabilityCvss3AttackComplexityType getAttackComplexity() {
        return attackComplexity;
    }

    public void setAttackComplexity(VulnerabilityCvss3AttackComplexityType attackComplexity) {
        this.attackComplexity = attackComplexity;
    }

    public VulnerabilityCvss3AttackVectorType getAttackVector() {
        return attackVector;
    }

    public void setAttackVector(VulnerabilityCvss3AttackVectorType attackVector) {
        this.attackVector = attackVector;
    }

    public VulnerabilityCvss3AvailabilityImpactType getAvailabilityImpact() {
        return availabilityImpact;
    }

    public void setAvailabilityImpact(VulnerabilityCvss3AvailabilityImpactType availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    public BigDecimal getBaseScore() {
        return baseScore;
    }

    public void setBaseScore(BigDecimal baseScore) {
        this.baseScore = baseScore;
    }

    public VulnerabilityCvss3ConfidentialityImpactType getConfidentialityImpact() {
        return confidentialityImpact;
    }

    public void setConfidentialityImpact(VulnerabilityCvss3ConfidentialityImpactType confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    public BigDecimal getExploitabilitySubscore() {
        return exploitabilitySubscore;
    }

    public void setExploitabilitySubscore(BigDecimal exploitabilitySubscore) {
        this.exploitabilitySubscore = exploitabilitySubscore;
    }

    public BigDecimal getImpactSubscore() {
        return impactSubscore;
    }

    public void setImpactSubscore(BigDecimal impactSubscore) {
        this.impactSubscore = impactSubscore;
    }

    public VulnerabilityCvss3IntegrityImpactType getIntegrityImpact() {
        return integrityImpact;
    }

    public void setIntegrityImpact(VulnerabilityCvss3IntegrityImpactType integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    public VulnerabilityCvss3PrivilegesRequiredType getPrivilegesRequired() {
        return privilegesRequired;
    }

    public void setPrivilegesRequired(VulnerabilityCvss3PrivilegesRequiredType privilegesRequired) {
        this.privilegesRequired = privilegesRequired;
    }

    public VulnerabilityCvss3ScopeType getScope() {
        return scope;
    }

    public void setScope(VulnerabilityCvss3ScopeType scope) {
        this.scope = scope;
    }

    public VulnerabilitySeverityType getSeverity() {
        return severity;
    }

    public void setSeverity(VulnerabilitySeverityType severity) {
        this.severity = severity;
    }

    public VulnerabilityCvss3TemporalMetricsView getTemporalMetrics() {
        return temporalMetrics;
    }

    public void setTemporalMetrics(VulnerabilityCvss3TemporalMetricsView temporalMetrics) {
        this.temporalMetrics = temporalMetrics;
    }

    public VulnerabilityCvss3UserInteractionType getUserInteraction() {
        return userInteraction;
    }

    public void setUserInteraction(VulnerabilityCvss3UserInteractionType userInteraction) {
        this.userInteraction = userInteraction;
    }

    public String getVector() {
        return vector;
    }

    public void setVector(String vector) {
        this.vector = vector;
    }

}
