/*
 * blackduck-common-api
 *
 * Copyright (c) 2021 Synopsys, Inc.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.synopsys.integration.blackduck.api.manual.component;

import java.util.List;

public class VulnerabilityNotificationContent extends NotificationContentComponent {
    private int newVulnerabilityCount;
    private int updatedVulnerabilityCount;
    private int deletedVulnerabilityCount;
    private List<VulnerabilitySourceQualifiedId> newVulnerabilityIds;
    private List<VulnerabilitySourceQualifiedId> updatedVulnerabilityIds;
    private List<VulnerabilitySourceQualifiedId> deletedVulnerabilityIds;
    private String componentVersion;
    private String componentName;
    private String versionName;
    private String componentVersionOriginName;
    private List<AffectedProjectVersion> affectedProjectVersions;
    private String componentVersionOriginId;

    public int getNewVulnerabilityCount() {
        return newVulnerabilityCount;
    }

    public void setNewVulnerabilityCount(int newVulnerabilityCount) {
        this.newVulnerabilityCount = newVulnerabilityCount;
    }

    public int getUpdatedVulnerabilityCount() {
        return updatedVulnerabilityCount;
    }

    public void setUpdatedVulnerabilityCount(int updatedVulnerabilityCount) {
        this.updatedVulnerabilityCount = updatedVulnerabilityCount;
    }

    public int getDeletedVulnerabilityCount() {
        return deletedVulnerabilityCount;
    }

    public void setDeletedVulnerabilityCount(int deletedVulnerabilityCount) {
        this.deletedVulnerabilityCount = deletedVulnerabilityCount;
    }

    public List<VulnerabilitySourceQualifiedId> getNewVulnerabilityIds() {
        return newVulnerabilityIds;
    }

    public void setNewVulnerabilityIds(List<VulnerabilitySourceQualifiedId> newVulnerabilityIds) {
        this.newVulnerabilityIds = newVulnerabilityIds;
    }

    public List<VulnerabilitySourceQualifiedId> getUpdatedVulnerabilityIds() {
        return updatedVulnerabilityIds;
    }

    public void setUpdatedVulnerabilityIds(List<VulnerabilitySourceQualifiedId> updatedVulnerabilityIds) {
        this.updatedVulnerabilityIds = updatedVulnerabilityIds;
    }

    public List<VulnerabilitySourceQualifiedId> getDeletedVulnerabilityIds() {
        return deletedVulnerabilityIds;
    }

    public void setDeletedVulnerabilityIds(List<VulnerabilitySourceQualifiedId> deletedVulnerabilityIds) {
        this.deletedVulnerabilityIds = deletedVulnerabilityIds;
    }

    public String getComponentVersion() {
        return componentVersion;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
    }

    public String getComponentName() {
        return componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getVersionName() {
        return versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getComponentVersionOriginName() {
        return componentVersionOriginName;
    }

    public void setComponentVersionOriginName(String componentVersionOriginName) {
        this.componentVersionOriginName = componentVersionOriginName;
    }

    public List<AffectedProjectVersion> getAffectedProjectVersions() {
        return affectedProjectVersions;
    }

    public void setAffectedProjectVersions(List<AffectedProjectVersion> affectedProjectVersions) {
        this.affectedProjectVersions = affectedProjectVersions;
    }

    public String getComponentVersionOriginId() {
        return componentVersionOriginId;
    }

    public void setComponentVersionOriginId(String componentVersionOriginId) {
        this.componentVersionOriginId = componentVersionOriginId;
    }

}
