/*
 * blackduck-common-api
 *
 * Copyright (c) 2021 Synopsys, Inc.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.synopsys.integration.blackduck.api.manual.temporary.view;

import java.util.HashMap;
import java.util.Map;

import com.synopsys.integration.blackduck.api.core.BlackDuckView;
import com.synopsys.integration.blackduck.api.core.response.LinkResponse;
import com.synopsys.integration.blackduck.api.core.response.LinkSingleResponse;
import com.synopsys.integration.blackduck.api.generated.component.VulnerabilityCvss2View;
import com.synopsys.integration.blackduck.api.generated.component.VulnerabilityCvss3View;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilitySourceType;
import com.synopsys.integration.blackduck.api.generated.response.CweView;
import com.synopsys.integration.blackduck.api.manual.temporary.component.VulnerabilityClassificationView;

//this file should not be edited - if changes are necessary, the generator should be updated, then this file should be re-created
public class VulnerabilityView extends BlackDuckView {
    public static final Map<String, LinkResponse> links = new HashMap<>();

    public static final String REFERENCE_LINK = "reference";
    public static final String CWES_LINK = "cwes";
    public static final String RELATED_VULNERABILITIES_LINK = "related-vulnerabilities";

    public static final LinkSingleResponse<CweView> CWES_LINK_RESPONSE = new LinkSingleResponse<CweView>(CWES_LINK, CweView.class);
    public static final LinkSingleResponse<VulnerabilityView> RELATED_VULNERABILITIES_LINK_RESPONSE = new LinkSingleResponse<VulnerabilityView>(RELATED_VULNERABILITIES_LINK, VulnerabilityView.class);

    static {
        links.put(CWES_LINK, CWES_LINK_RESPONSE);
        links.put(RELATED_VULNERABILITIES_LINK, RELATED_VULNERABILITIES_LINK_RESPONSE);
    }

    private java.util.List<VulnerabilityClassificationView> classifications;
    private String credit;
    private VulnerabilityCvss2View cvss2;
    private VulnerabilityCvss3View cvss3;
    private String description;
    private java.util.Date disclosureDate;
    private java.util.Date discoveryDate;
    private java.util.Date exploitPublishDate;
    private String name;
    private Boolean parentAdvisory;
    private java.util.Date publishedDate;
    private String severity;
    private String solution;
    private java.util.Date solutionDate;
    private VulnerabilitySourceType source;
    private String technicalDescription;
    private String title;
    private Boolean underReview;
    private java.util.Date updatedDate;
    private Boolean useCvss3;
    private java.util.Date vendorFixDate;
    private java.util.Date vendorNotifiedDate;
    private String workaround;
    private Boolean zeroDay;

    public java.util.List<VulnerabilityClassificationView> getClassifications() {
        return classifications;
    }

    public void setClassifications(java.util.List<VulnerabilityClassificationView> classifications) {
        this.classifications = classifications;
    }

    public String getCredit() {
        return credit;
    }

    public void setCredit(String credit) {
        this.credit = credit;
    }

    public VulnerabilityCvss2View getCvss2() {
        return cvss2;
    }

    public void setCvss2(VulnerabilityCvss2View cvss2) {
        this.cvss2 = cvss2;
    }

    public VulnerabilityCvss3View getCvss3() {
        return cvss3;
    }

    public void setCvss3(VulnerabilityCvss3View cvss3) {
        this.cvss3 = cvss3;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public java.util.Date getDisclosureDate() {
        return disclosureDate;
    }

    public void setDisclosureDate(java.util.Date disclosureDate) {
        this.disclosureDate = disclosureDate;
    }

    public java.util.Date getDiscoveryDate() {
        return discoveryDate;
    }

    public void setDiscoveryDate(java.util.Date discoveryDate) {
        this.discoveryDate = discoveryDate;
    }

    public java.util.Date getExploitPublishDate() {
        return exploitPublishDate;
    }

    public void setExploitPublishDate(java.util.Date exploitPublishDate) {
        this.exploitPublishDate = exploitPublishDate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getParentAdvisory() {
        return parentAdvisory;
    }

    public void setParentAdvisory(Boolean parentAdvisory) {
        this.parentAdvisory = parentAdvisory;
    }

    public java.util.Date getPublishedDate() {
        return publishedDate;
    }

    public void setPublishedDate(java.util.Date publishedDate) {
        this.publishedDate = publishedDate;
    }

    public String getSeverity() {
        return severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSolution() {
        return solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public java.util.Date getSolutionDate() {
        return solutionDate;
    }

    public void setSolutionDate(java.util.Date solutionDate) {
        this.solutionDate = solutionDate;
    }

    public VulnerabilitySourceType getSource() {
        return source;
    }

    public void setSource(VulnerabilitySourceType source) {
        this.source = source;
    }

    public String getTechnicalDescription() {
        return technicalDescription;
    }

    public void setTechnicalDescription(String technicalDescription) {
        this.technicalDescription = technicalDescription;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Boolean getUnderReview() {
        return underReview;
    }

    public void setUnderReview(Boolean underReview) {
        this.underReview = underReview;
    }

    public java.util.Date getUpdatedDate() {
        return updatedDate;
    }

    public void setUpdatedDate(java.util.Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public Boolean getUseCvss3() {
        return useCvss3;
    }

    public void setUseCvss3(Boolean useCvss3) {
        this.useCvss3 = useCvss3;
    }

    public java.util.Date getVendorFixDate() {
        return vendorFixDate;
    }

    public void setVendorFixDate(java.util.Date vendorFixDate) {
        this.vendorFixDate = vendorFixDate;
    }

    public java.util.Date getVendorNotifiedDate() {
        return vendorNotifiedDate;
    }

    public void setVendorNotifiedDate(java.util.Date vendorNotifiedDate) {
        this.vendorNotifiedDate = vendorNotifiedDate;
    }

    public String getWorkaround() {
        return workaround;
    }

    public void setWorkaround(String workaround) {
        this.workaround = workaround;
    }

    public Boolean getZeroDay() {
        return zeroDay;
    }

    public void setZeroDay(Boolean zeroDay) {
        this.zeroDay = zeroDay;
    }

}
