/*
 * blackduck-common
 *
 * Copyright (c) 2021 Synopsys, Inc.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.synopsys.integration.blackduck.http.client;

import java.io.IOException;
import java.util.Optional;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.ErrorResponse;
import com.synopsys.integration.rest.response.Response;

public interface BlackDuckHttpClient {
    Response execute(Request request) throws IntegrationException;

    Optional<Response> executeGetRequestIfModifiedSince(Request getRequest, long timeToCheck) throws IntegrationException, IOException;

    Response attemptAuthentication() throws IntegrationException;

    boolean isAlreadyAuthenticated(HttpUriRequest request);

    Optional<ErrorResponse> extractErrorResponse(String responseContent);

    void handleErrorResponse(HttpUriRequest request, Response response);

    void throwExceptionForError(Response response) throws IntegrationException;

    HttpUrl getBaseUrl();

    String getUserAgentString();

    HttpClientBuilder getHttpClientBuilder();

    int getTimeoutInSeconds();

    boolean isAlwaysTrustServerCertificate();

    ProxyInfo getProxyInfo();

    IntLogger getLogger();

}
