/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.binaryscanner;

import com.synopsys.integration.blackduck.codelocation.binaryscanner.BinaryScan;
import com.synopsys.integration.blackduck.codelocation.binaryscanner.BinaryScanOutput;
import com.synopsys.integration.blackduck.http.BlackDuckRequestBuilder;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.response.Response;
import com.synopsys.integration.util.NameVersion;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class BinaryScanCallable
implements Callable<BinaryScanOutput> {
    private final BlackDuckApiClient blackDuckApiClient;
    private final BlackDuckRequestFactory blackDuckRequestFactory;
    private final BinaryScan binaryScan;
    private final NameVersion projectAndVersion;
    private final String codeLocationName;

    public BinaryScanCallable(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, BinaryScan binaryScan) {
        this.blackDuckApiClient = blackDuckApiClient;
        this.blackDuckRequestFactory = blackDuckRequestFactory;
        this.binaryScan = binaryScan;
        this.projectAndVersion = new NameVersion(binaryScan.getProjectName(), binaryScan.getProjectVersion());
        this.codeLocationName = binaryScan.getCodeLocationName();
    }

    @Override
    public BinaryScanOutput call() {
        BinaryScanOutput binaryScanOutput;
        block9: {
            HashMap<String, String> textParts = new HashMap<String, String>();
            textParts.put("projectName", this.binaryScan.getProjectName());
            textParts.put("version", this.binaryScan.getProjectVersion());
            textParts.put("codeLocationName", this.binaryScan.getCodeLocationName());
            HashMap<String, File> binaryParts = new HashMap<String, File>();
            binaryParts.put("fileupload", this.binaryScan.getBinaryFile());
            BlackDuckRequestBuilder requestBuilder = this.blackDuckRequestFactory.createCommonPostRequestBuilder(binaryParts, textParts);
            Response response = this.blackDuckApiClient.execute(BlackDuckApiClient.UPLOADS_PATH, requestBuilder);
            try {
                binaryScanOutput = BinaryScanOutput.FROM_RESPONSE(this.projectAndVersion, this.codeLocationName, response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IntegrationRestException e) {
                    return BinaryScanOutput.FROM_INTEGRATION_REST_EXCEPTION(this.projectAndVersion, this.codeLocationName, e);
                }
                catch (IntegrationException | IOException e) {
                    String errorMessage = String.format("Failed to upload binary file: %s because %s", this.binaryScan.getBinaryFile().getAbsolutePath(), e.getMessage());
                    return BinaryScanOutput.FAILURE(this.projectAndVersion, this.codeLocationName, errorMessage, (Exception)e);
                }
            }
            response.close();
        }
        return binaryScanOutput;
    }
}

