/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http;

import com.synopsys.integration.blackduck.http.BlackDuckPageDefinition;
import com.synopsys.integration.blackduck.http.BlackDuckQuery;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFilter;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.body.BodyContent;
import com.synopsys.integration.rest.request.Request;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BlackDuckRequestBuilder {
    private final Request.Builder requestBuilder;

    public BlackDuckRequestBuilder(Request.Builder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    public Request build() {
        return (Request)this.requestBuilder.build();
    }

    public Request.Builder getRequestBuilder() {
        return this.requestBuilder;
    }

    public BlackDuckRequestBuilder url(HttpUrl url) {
        this.requestBuilder.url(url);
        return this;
    }

    public BlackDuckRequestBuilder setBlackDuckPageDefinition(BlackDuckPageDefinition blackDuckPageDefinition) {
        this.requestBuilder.setQueryParameter("limit", String.valueOf(blackDuckPageDefinition.getLimit()));
        this.requestBuilder.setQueryParameter("offset", String.valueOf(blackDuckPageDefinition.getOffset()));
        return this;
    }

    public BlackDuckRequestBuilder addBlackDuckQuery(Optional<BlackDuckQuery> blackDuckQuery) {
        if (blackDuckQuery.isPresent()) {
            this.requestBuilder.addQueryParameter("q", blackDuckQuery.get().getParameter());
        }
        return this;
    }

    public BlackDuckRequestBuilder addBlackDuckFilter(BlackDuckRequestFilter blackDuckRequestFilter) {
        if (blackDuckRequestFilter != null) {
            blackDuckRequestFilter.getFilterParameters().forEach(parameter -> this.requestBuilder.addQueryParameter("filter", parameter));
        }
        return this;
    }

    public BlackDuckRequestBuilder method(HttpMethod method) {
        this.requestBuilder.method(method);
        return this;
    }

    public BlackDuckRequestBuilder acceptMimeType(String acceptHeader) {
        this.requestBuilder.acceptMimeType(acceptHeader);
        return this;
    }

    public BlackDuckRequestBuilder bodyEncoding(Charset bodyEncoding) {
        this.requestBuilder.bodyEncoding(bodyEncoding);
        return this;
    }

    public BlackDuckRequestBuilder queryParameters(Map<String, Set<String>> queryParameters) {
        this.requestBuilder.queryParameters(queryParameters);
        return this;
    }

    public BlackDuckRequestBuilder addQueryParameter(String key, String value) {
        this.requestBuilder.addQueryParameter(key, value);
        return this;
    }

    public BlackDuckRequestBuilder headers(Map<String, String> headers) {
        this.requestBuilder.headers(headers);
        return this;
    }

    public BlackDuckRequestBuilder addHeader(String key, String value) {
        this.requestBuilder.addHeader(key, value);
        return this;
    }

    public BlackDuckRequestBuilder bodyContent(BodyContent bodyContent) {
        this.requestBuilder.bodyContent(bodyContent);
        return this;
    }

    public HttpUrl getUrl() {
        return this.requestBuilder.getUrl();
    }

    public HttpMethod getMethod() {
        return this.requestBuilder.getMethod();
    }

    public String getAcceptMimeType() {
        return this.requestBuilder.getAcceptMimeType();
    }

    public Charset getBodyEncoding() {
        return this.requestBuilder.getBodyEncoding();
    }

    public Map<String, Set<String>> getQueryParameters() {
        return this.requestBuilder.getQueryParameters();
    }

    public Map<String, String> getHeaders() {
        return this.requestBuilder.getHeaders();
    }

    public BodyContent getBodyContent() {
        return this.requestBuilder.getBodyContent();
    }
}

