/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http.client;

import com.synopsys.integration.blackduck.api.generated.discovery.BlackDuckMediaTypeDiscovery;
import com.synopsys.integration.blackduck.exception.BlackDuckApiException;
import com.synopsys.integration.blackduck.http.client.BlackDuckHttpClient;
import com.synopsys.integration.blackduck.http.client.BlackDuckRedirectStrategy;
import com.synopsys.integration.blackduck.useragent.BlackDuckCommon;
import com.synopsys.integration.blackduck.useragent.UserAgentBuilder;
import com.synopsys.integration.blackduck.useragent.UserAgentItem;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.client.AuthenticatingIntHttpClient;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.ErrorResponse;
import com.synopsys.integration.rest.response.Response;
import com.synopsys.integration.rest.support.AuthenticationSupport;
import com.synopsys.integration.util.NameVersion;
import java.util.Optional;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class DefaultBlackDuckHttpClient
extends AuthenticatingIntHttpClient
implements BlackDuckHttpClient {
    private final HttpUrl baseUrl;
    private final BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery;
    private final String userAgentString;
    protected final AuthenticationSupport authenticationSupport;

    public DefaultBlackDuckHttpClient(IntLogger logger, int timeout, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, HttpUrl baseUrl, NameVersion solutionDetails, AuthenticationSupport authenticationSupport, BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery) {
        this(logger, timeout, alwaysTrustServerCertificate, proxyInfo, baseUrl, new UserAgentItem(solutionDetails), BlackDuckCommon.createUserAgentItem(), authenticationSupport, blackDuckMediaTypeDiscovery);
    }

    public DefaultBlackDuckHttpClient(IntLogger logger, int timeout, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, HttpUrl baseUrl, UserAgentItem solutionUserAgentItem, AuthenticationSupport authenticationSupport, BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery) {
        this(logger, timeout, alwaysTrustServerCertificate, proxyInfo, baseUrl, solutionUserAgentItem, BlackDuckCommon.createUserAgentItem(), authenticationSupport, blackDuckMediaTypeDiscovery);
    }

    public DefaultBlackDuckHttpClient(IntLogger logger, int timeout, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, HttpUrl baseUrl, UserAgentItem solutionUserAgentItem, UserAgentItem blackDuckCommonUserAgentItem, AuthenticationSupport authenticationSupport, BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery) {
        super(logger, timeout, alwaysTrustServerCertificate, proxyInfo);
        if (null == baseUrl) {
            throw new IllegalArgumentException("No base url was provided.");
        }
        this.baseUrl = baseUrl;
        this.blackDuckMediaTypeDiscovery = blackDuckMediaTypeDiscovery;
        UserAgentBuilder userAgentBuilder = new UserAgentBuilder();
        userAgentBuilder.addUserAgent(solutionUserAgentItem);
        userAgentBuilder.addUserAgent(blackDuckCommonUserAgentItem);
        this.userAgentString = userAgentBuilder.createFullUserAgentString();
        this.authenticationSupport = authenticationSupport;
    }

    @Override
    public Response execute(Request request) throws IntegrationException {
        Request.Builder requestBuilder = request.createBuilder();
        HttpUrl httpUrl = requestBuilder.getUrl();
        String mediaType = requestBuilder.getAcceptMimeType();
        String replacementMediaType = this.blackDuckMediaTypeDiscovery.determineMediaType(httpUrl, mediaType);
        requestBuilder.acceptMimeType(replacementMediaType);
        if (!requestBuilder.getHeaders().containsKey("User-Agent")) {
            requestBuilder.addHeader("User-Agent", this.userAgentString);
        }
        request = (Request)requestBuilder.build();
        try {
            return super.execute(request);
        }
        catch (IntegrationRestException e) {
            throw this.transformException(e);
        }
    }

    @Override
    public boolean isAlreadyAuthenticated(HttpUriRequest request) {
        return this.authenticationSupport.isTokenAlreadyAuthenticated(request);
    }

    @Override
    public void handleErrorResponse(HttpUriRequest request, Response response) {
        super.handleErrorResponse(request, response);
        this.authenticationSupport.handleTokenErrorResponse((AuthenticatingIntHttpClient)this, request, response);
    }

    @Override
    public void throwExceptionForError(Response response) throws IntegrationException {
        try {
            response.throwExceptionForError();
        }
        catch (IntegrationRestException e) {
            throw this.transformException(e);
        }
    }

    @Override
    public HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getUserAgentString() {
        return this.userAgentString;
    }

    @Override
    public HttpClientBuilder getHttpClientBuilder() {
        return this.getClientBuilder();
    }

    protected void addToHttpClientBuilder(HttpClientBuilder httpClientBuilder, RequestConfig.Builder defaultRequestConfigBuilder) {
        super.addToHttpClientBuilder(httpClientBuilder, defaultRequestConfigBuilder);
        httpClientBuilder.setRedirectStrategy((RedirectStrategy)new BlackDuckRedirectStrategy());
    }

    private IntegrationException transformException(IntegrationRestException e) {
        String httpResponseContent = e.getHttpResponseContent();
        Optional optionalErrorResponse = this.extractErrorResponse(httpResponseContent);
        if (optionalErrorResponse.isPresent()) {
            ErrorResponse errorResponse = (ErrorResponse)optionalErrorResponse.get();
            String apiExceptionErrorMessage = String.format("%s [HTTP Error]: %s", errorResponse.getErrorMessage(), e.getMessage());
            return new BlackDuckApiException(e, apiExceptionErrorMessage, errorResponse.getErrorCode());
        }
        return e;
    }
}

