/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.google.gson.Gson;
import com.synopsys.integration.blackduck.api.core.BlackDuckComponent;
import com.synopsys.integration.blackduck.api.core.BlackDuckPath;
import com.synopsys.integration.blackduck.api.core.BlackDuckResponse;
import com.synopsys.integration.blackduck.api.core.BlackDuckView;
import com.synopsys.integration.blackduck.api.core.response.BlackDuckPathMultipleResponses;
import com.synopsys.integration.blackduck.api.core.response.BlackDuckPathSingleResponse;
import com.synopsys.integration.blackduck.api.core.response.LinkMultipleResponses;
import com.synopsys.integration.blackduck.api.core.response.LinkSingleResponse;
import com.synopsys.integration.blackduck.http.BlackDuckPageDefinition;
import com.synopsys.integration.blackduck.http.BlackDuckPageResponse;
import com.synopsys.integration.blackduck.http.BlackDuckRequestBuilder;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.http.PagedRequest;
import com.synopsys.integration.blackduck.http.client.BlackDuckHttpClient;
import com.synopsys.integration.blackduck.http.transform.BlackDuckJsonTransformer;
import com.synopsys.integration.blackduck.http.transform.BlackDuckResponseTransformer;
import com.synopsys.integration.blackduck.http.transform.BlackDuckResponsesTransformer;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.function.ThrowingBiFunction;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.Response;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;

public class BlackDuckApiClient {
    public static final BlackDuckPath BOMIMPORT_PATH = new BlackDuckPath("/api/bom-import");
    public static final BlackDuckPath SCANSUMMARIES_PATH = new BlackDuckPath("/api/scan-summaries");
    public static final BlackDuckPath UPLOADS_PATH = new BlackDuckPath("/api/uploads");
    public static final BlackDuckPath SCAN_DATA_PATH = new BlackDuckPath("/api/scan/data/");
    public static final BlackDuckPath SCAN_DEVELOPER_MODE_PATH = new BlackDuckPath("/api/developer-scans");
    private final BlackDuckHttpClient blackDuckHttpClient;
    private final BlackDuckJsonTransformer blackDuckJsonTransformer;
    private final BlackDuckResponseTransformer blackDuckResponseTransformer;
    private final BlackDuckResponsesTransformer blackDuckResponsesTransformer;
    private final HttpUrl blackDuckBaseUrl;
    private final Gson gson;
    private final BlackDuckRequestFactory blackDuckRequestFactory;

    public BlackDuckApiClient(BlackDuckHttpClient blackDuckHttpClient, Gson gson, BlackDuckJsonTransformer blackDuckJsonTransformer, BlackDuckResponseTransformer blackDuckResponseTransformer, BlackDuckResponsesTransformer blackDuckResponsesTransformer, BlackDuckRequestFactory blackDuckRequestFactory) {
        this.blackDuckHttpClient = blackDuckHttpClient;
        this.blackDuckBaseUrl = blackDuckHttpClient.getBaseUrl();
        this.gson = gson;
        this.blackDuckJsonTransformer = blackDuckJsonTransformer;
        this.blackDuckResponseTransformer = blackDuckResponseTransformer;
        this.blackDuckResponsesTransformer = blackDuckResponsesTransformer;
        this.blackDuckRequestFactory = blackDuckRequestFactory;
    }

    public <T extends BlackDuckResponse> T transformResponse(Response response, Class<T> clazz) throws IntegrationException {
        return this.blackDuckJsonTransformer.getResponse(response, clazz);
    }

    public String convertToJson(Object obj) {
        return this.gson.toJson(obj);
    }

    public HttpUrl getUrl(BlackDuckPath path) throws IntegrationException {
        return this.fullBlackDuckUrl(path);
    }

    public <T extends BlackDuckResponse> List<T> getSomeMatchingResponses(BlackDuckPathMultipleResponses<T> blackDuckPathMultipleResponses, Predicate<T> predicate, int totalLimit) throws IntegrationException {
        return this.getSomeMatchingResponses(blackDuckPathMultipleResponses, this.blackDuckRequestFactory.createCommonGetRequestBuilder(), predicate, totalLimit);
    }

    public <T extends BlackDuckResponse> List<T> getSomeMatchingResponses(BlackDuckPathMultipleResponses<T> blackDuckPathMultipleResponses, BlackDuckRequestBuilder requestBuilder, Predicate<T> predicate, int totalLimit) throws IntegrationException {
        return this.getBlackDuckPathResponses(blackDuckPathMultipleResponses, requestBuilder, (pagedRequest, responseClass) -> this.blackDuckResponsesTransformer.getSomeMatchingResponses((PagedRequest)pagedRequest, responseClass, predicate, totalLimit));
    }

    public <T extends BlackDuckResponse> List<T> getAllResponses(BlackDuckPathMultipleResponses<T> blackDuckPathMultipleResponses) throws IntegrationException {
        return this.getAllResponses(blackDuckPathMultipleResponses, this.blackDuckRequestFactory.createCommonGetRequestBuilder());
    }

    public <T extends BlackDuckResponse> List<T> getAllResponses(BlackDuckPathMultipleResponses<T> blackDuckPathMultipleResponses, BlackDuckRequestBuilder requestBuilder) throws IntegrationException {
        return this.getBlackDuckPathResponses(blackDuckPathMultipleResponses, requestBuilder, this.blackDuckResponsesTransformer::getAllResponses);
    }

    public <T extends BlackDuckResponse> List<T> getSomeResponses(BlackDuckPathMultipleResponses<T> blackDuckPathMultipleResponses, int totalLimit) throws IntegrationException {
        return this.getSomeResponses(blackDuckPathMultipleResponses, this.blackDuckRequestFactory.createCommonGetRequestBuilder(), totalLimit);
    }

    public <T extends BlackDuckResponse> List<T> getSomeResponses(BlackDuckPathMultipleResponses<T> blackDuckPathMultipleResponses, BlackDuckRequestBuilder requestBuilder, int totalLimit) throws IntegrationException {
        return this.getBlackDuckPathResponses(blackDuckPathMultipleResponses, requestBuilder, (pagedRequest, responseClass) -> this.blackDuckResponsesTransformer.getSomeResponses((PagedRequest)pagedRequest, responseClass, totalLimit));
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getPageResponse(BlackDuckPathMultipleResponses<T> blackDuckPathMultipleResponses, BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        HttpUrl url = this.fullBlackDuckUrl(blackDuckPathMultipleResponses.getBlackDuckPath());
        Class responseClass = blackDuckPathMultipleResponses.getResponseClass();
        return this.getPageResponse(url, responseClass, blackDuckPageDefinition);
    }

    public <T extends BlackDuckResponse> T getResponse(BlackDuckPathSingleResponse<T> blackDuckPathSingleResponse, BlackDuckRequestBuilder requestBuilder) throws IntegrationException {
        HttpUrl url = this.fullBlackDuckUrl(blackDuckPathSingleResponse.getBlackDuckPath());
        requestBuilder.url(url);
        return this.blackDuckResponseTransformer.getResponse(requestBuilder.build(), blackDuckPathSingleResponse.getResponseClass());
    }

    public <T extends BlackDuckResponse> T getResponse(BlackDuckPathSingleResponse<T> blackDuckPathSingleResponse) throws IntegrationException {
        return this.getResponse(blackDuckPathSingleResponse, this.blackDuckRequestFactory.createCommonGetRequestBuilder());
    }

    public <T extends BlackDuckResponse> List<T> getSomeMatchingResponses(BlackDuckView blackDuckView, LinkMultipleResponses<T> linkMultipleResponses, Predicate<T> predicate, int totalLimit) throws IntegrationException {
        return this.getSomeMatchingResponses(blackDuckView, linkMultipleResponses, this.blackDuckRequestFactory.createCommonGetRequestBuilder(), predicate, totalLimit);
    }

    public <T extends BlackDuckResponse> List<T> getSomeMatchingResponses(BlackDuckView blackDuckView, LinkMultipleResponses<T> linkMultipleResponses, BlackDuckRequestBuilder requestBuilder, Predicate<T> predicate, int totalLimit) throws IntegrationException {
        return this.getBlackDuckViewResponses(blackDuckView, linkMultipleResponses, requestBuilder, (pagedRequest, responseClass) -> this.blackDuckResponsesTransformer.getSomeMatchingResponses((PagedRequest)pagedRequest, responseClass, predicate, totalLimit));
    }

    public <T extends BlackDuckResponse> List<T> getAllResponses(BlackDuckView blackDuckView, LinkMultipleResponses<T> linkMultipleResponses) throws IntegrationException {
        return this.getAllResponses(blackDuckView, linkMultipleResponses, this.blackDuckRequestFactory.createCommonGetRequestBuilder());
    }

    public <T extends BlackDuckResponse> List<T> getAllResponses(BlackDuckView blackDuckView, LinkMultipleResponses<T> linkMultipleResponses, BlackDuckRequestBuilder requestBuilder) throws IntegrationException {
        return this.getBlackDuckViewResponses(blackDuckView, linkMultipleResponses, requestBuilder, this.blackDuckResponsesTransformer::getAllResponses);
    }

    public <T extends BlackDuckResponse> List<T> getSomeResponses(BlackDuckView blackDuckView, LinkMultipleResponses<T> linkMultipleResponses, int totalLimit) throws IntegrationException {
        return this.getSomeResponses(blackDuckView, linkMultipleResponses, this.blackDuckRequestFactory.createCommonGetRequestBuilder(), totalLimit);
    }

    public <T extends BlackDuckResponse> List<T> getSomeResponses(BlackDuckView blackDuckView, LinkMultipleResponses<T> linkMultipleResponses, BlackDuckRequestBuilder requestBuilder, int totalLimit) throws IntegrationException {
        return this.getBlackDuckViewResponses(blackDuckView, linkMultipleResponses, requestBuilder, (pagedRequest, responseClass) -> this.blackDuckResponsesTransformer.getSomeResponses((PagedRequest)pagedRequest, responseClass, totalLimit));
    }

    public <T extends BlackDuckResponse> Optional<T> getResponse(BlackDuckView blackDuckView, LinkSingleResponse<T> linkSingleResponse) throws IntegrationException {
        try {
            HttpUrl url = blackDuckView.getFirstLink(linkSingleResponse.getLink());
            Request request = this.blackDuckRequestFactory.createCommonGetRequest(url);
            return Optional.of(this.blackDuckResponseTransformer.getResponse(request, linkSingleResponse.getResponseClass()));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    public <T extends BlackDuckResponse> List<T> getAllResponses(HttpUrl url, Class<T> responseClass) throws IntegrationException {
        BlackDuckRequestBuilder requestBuilder = this.blackDuckRequestFactory.createCommonGetRequestBuilder(url);
        return this.blackDuckResponsesTransformer.getAllResponses(new PagedRequest(requestBuilder), responseClass).getItems();
    }

    public <T extends BlackDuckResponse> List<T> getSomeResponses(HttpUrl url, Class<T> responseClass, int totalLimit) throws IntegrationException {
        BlackDuckRequestBuilder requestBuilder = this.blackDuckRequestFactory.createCommonGetRequestBuilder(url);
        return this.blackDuckResponsesTransformer.getSomeResponses(new PagedRequest(requestBuilder), responseClass, totalLimit).getItems();
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getPageResponse(HttpUrl url, Class<T> responseClass, BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        BlackDuckRequestBuilder requestBuilder = this.blackDuckRequestFactory.createCommonGetRequestBuilder(url);
        return this.getPageResponse(requestBuilder, responseClass, blackDuckPageDefinition);
    }

    public <T extends BlackDuckResponse> List<T> getAllResponses(BlackDuckRequestBuilder requestBuilder, Class<T> responseClass) throws IntegrationException {
        return this.blackDuckResponsesTransformer.getAllResponses(new PagedRequest(requestBuilder), responseClass).getItems();
    }

    public <T extends BlackDuckResponse> List<T> getSomeResponses(BlackDuckRequestBuilder requestBuilder, Class<T> responseClass, int totalLimit) throws IntegrationException {
        return this.blackDuckResponsesTransformer.getSomeResponses(new PagedRequest(requestBuilder), responseClass, totalLimit).getItems();
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getPageResponse(BlackDuckRequestBuilder requestBuilder, Class<T> responseClass, BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        PagedRequest pagedRequest = new PagedRequest(requestBuilder, blackDuckPageDefinition);
        return this.blackDuckResponsesTransformer.getOnePageOfResponses(pagedRequest, responseClass);
    }

    public <T extends BlackDuckResponse> T getResponse(HttpUrl url, Class<T> responseClass) throws IntegrationException {
        Request request = this.blackDuckRequestFactory.createCommonGetRequest(url);
        return this.blackDuckResponseTransformer.getResponse(request, responseClass);
    }

    @Deprecated
    public <T extends BlackDuckResponse> T getResponse(LinkSingleResponse<T> linkSingleResponse) throws IntegrationException {
        HttpUrl url = new HttpUrl(linkSingleResponse.getLink());
        Request request = this.blackDuckRequestFactory.createCommonGetRequest(url);
        return this.blackDuckResponseTransformer.getResponse(request, linkSingleResponse.getResponseClass());
    }

    public HttpUrl post(BlackDuckPath blackDuckPath, BlackDuckComponent blackDuckComponent) throws IntegrationException {
        HttpUrl url = this.fullBlackDuckUrl(blackDuckPath);
        return this.post(url, blackDuckComponent);
    }

    public HttpUrl post(HttpUrl url, BlackDuckComponent blackDuckComponent) throws IntegrationException {
        String json = this.gson.toJson((Object)blackDuckComponent);
        Request request = this.blackDuckRequestFactory.createCommonPostRequestBuilder(url, json).build();
        return this.executePostRequestAndRetrieveURL(request);
    }

    public void delete(BlackDuckView blackDuckView) throws IntegrationException {
        HttpUrl url = blackDuckView.getHref();
        this.delete(url);
    }

    public void delete(HttpUrl url) throws IntegrationException {
        Request request = (Request)new Request.Builder(url, HttpMethod.DELETE).build();
        try {
            Response response = this.execute(request);
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), (Throwable)e);
        }
    }

    public void put(BlackDuckView blackDuckView) throws IntegrationException {
        HttpUrl url = blackDuckView.getHref();
        String json = this.blackDuckJsonTransformer.producePatchedJson((BlackDuckResponse)blackDuckView);
        Request request = this.blackDuckRequestFactory.createCommonPutRequestBuilder(url, json).build();
        try {
            Response response = this.execute(request);
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), (Throwable)e);
        }
    }

    public Response get(HttpUrl url) throws IntegrationException {
        Request request = this.blackDuckRequestFactory.createCommonGetRequest(url);
        return this.execute(request);
    }

    public Response get(BlackDuckPath path) throws IntegrationException {
        HttpUrl url = this.fullBlackDuckUrl(path);
        Request request = this.blackDuckRequestFactory.createCommonGetRequest(url);
        return this.execute(request);
    }

    public Response execute(BlackDuckPath path, BlackDuckRequestBuilder requestBuilder) throws IntegrationException {
        HttpUrl url = this.fullBlackDuckUrl(path);
        requestBuilder.url(url);
        Request request = requestBuilder.build();
        return this.execute(request);
    }

    public Response execute(Request request) throws IntegrationException {
        Response response = this.blackDuckHttpClient.execute(request);
        this.blackDuckHttpClient.throwExceptionForError(response);
        return response;
    }

    public HttpUrl executePostRequestAndRetrieveURL(BlackDuckPath path, BlackDuckRequestBuilder requestBuilder) throws IntegrationException {
        HttpUrl url = this.fullBlackDuckUrl(path);
        requestBuilder.url(url);
        return this.executePostRequestAndRetrieveURL(requestBuilder.build());
    }

    public HttpUrl executePostRequestAndRetrieveURL(Request request) throws IntegrationException {
        HttpUrl httpUrl;
        block8: {
            Response response = this.execute(request);
            try {
                httpUrl = new HttpUrl(response.getHeaderValue("location"));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IntegrationException(e.getMessage(), (Throwable)e);
                }
            }
            response.close();
        }
        return httpUrl;
    }

    private <T extends BlackDuckResponse> List<T> getBlackDuckPathResponses(BlackDuckPathMultipleResponses<T> blackDuckPathMultipleResponses, BlackDuckRequestBuilder requestBuilder, ThrowingBiFunction<PagedRequest, Class<T>, BlackDuckPageResponse<T>, IntegrationException> responsesTransformer) throws IntegrationException {
        HttpUrl url = this.fullBlackDuckUrl(blackDuckPathMultipleResponses.getBlackDuckPath());
        Class responseClass = blackDuckPathMultipleResponses.getResponseClass();
        return this.getSpecialResponses(url, responseClass, requestBuilder, responsesTransformer);
    }

    private <T extends BlackDuckResponse> List<T> getBlackDuckViewResponses(BlackDuckView blackDuckView, LinkMultipleResponses<T> linkMultipleResponses, BlackDuckRequestBuilder requestBuilder, ThrowingBiFunction<PagedRequest, Class<T>, BlackDuckPageResponse<T>, IntegrationException> responsesTransformer) throws IntegrationException {
        HttpUrl url = blackDuckView.getFirstLink(linkMultipleResponses.getLink());
        Class responseClass = linkMultipleResponses.getResponseClass();
        return this.getSpecialResponses(url, responseClass, requestBuilder, responsesTransformer);
    }

    private <T extends BlackDuckResponse> List<T> getSpecialResponses(HttpUrl httpUrl, Class<T> responseClass, BlackDuckRequestBuilder requestBuilder, ThrowingBiFunction<PagedRequest, Class<T>, BlackDuckPageResponse<T>, IntegrationException> responsesTransformer) throws IntegrationException {
        requestBuilder.url(httpUrl);
        return ((BlackDuckPageResponse)((Object)responsesTransformer.apply((Object)new PagedRequest(requestBuilder), responseClass))).getItems();
    }

    private HttpUrl fullBlackDuckUrl(BlackDuckPath blackDuckPath) throws IntegrationException {
        return blackDuckPath.getFullBlackDuckUrl(this.blackDuckBaseUrl);
    }
}

