/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.dataservice;

import com.synopsys.integration.blackduck.api.core.BlackDuckView;
import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.view.UserView;
import com.synopsys.integration.blackduck.api.manual.contract.NotificationViewData;
import com.synopsys.integration.blackduck.api.manual.temporary.enumeration.NotificationType;
import com.synopsys.integration.blackduck.api.manual.view.NotificationUserView;
import com.synopsys.integration.blackduck.api.manual.view.NotificationView;
import com.synopsys.integration.blackduck.http.BlackDuckPageDefinition;
import com.synopsys.integration.blackduck.http.BlackDuckPageResponse;
import com.synopsys.integration.blackduck.http.BlackDuckRequestBuilder;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFilter;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NotificationService
extends DataService {
    public NotificationService(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger) {
        super(blackDuckApiClient, blackDuckRequestFactory, logger);
    }

    public List<NotificationView> getAllNotifications(Date startDate, Date endDate) throws IntegrationException {
        List<String> allKnownNotificationTypes = this.getAllKnownNotificationTypes();
        BlackDuckRequestBuilder requestBuilder = this.createNotificationRequestBuilder(startDate, endDate, allKnownNotificationTypes);
        return this.blackDuckApiClient.getAllResponses(ApiDiscovery.NOTIFICATIONS_LINK_RESPONSE, requestBuilder);
    }

    public BlackDuckPageResponse<NotificationView> getPageOfNotifications(Date startDate, Date endDate, BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        List<String> allKnownNotificationTypes = this.getAllKnownNotificationTypes();
        BlackDuckRequestBuilder requestBuilder = this.createNotificationRequestBuilder(startDate, endDate, allKnownNotificationTypes);
        return this.blackDuckApiClient.getPageResponse(requestBuilder, NotificationView.class, blackDuckPageDefinition);
    }

    public List<NotificationUserView> getAllUserNotifications(UserView user, Date startDate, Date endDate) throws IntegrationException {
        List<String> allKnownNotificationTypes = this.getAllKnownNotificationTypes();
        BlackDuckRequestBuilder requestBuilder = this.prepareUserNotificationsRequest(user, startDate, endDate, allKnownNotificationTypes);
        return this.blackDuckApiClient.getAllResponses(requestBuilder, NotificationUserView.class);
    }

    public BlackDuckPageResponse getPageOfUserNotifications(UserView user, Date startDate, Date endDate, BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        List<String> allKnownNotificationTypes = this.getAllKnownNotificationTypes();
        BlackDuckRequestBuilder requestBuilder = this.prepareUserNotificationsRequest(user, startDate, endDate, allKnownNotificationTypes);
        return this.blackDuckApiClient.getPageResponse(requestBuilder, NotificationUserView.class, blackDuckPageDefinition);
    }

    public List<NotificationView> getFilteredNotifications(Date startDate, Date endDate, List<String> notificationTypesToInclude) throws IntegrationException {
        BlackDuckRequestBuilder requestBuilder = this.createNotificationRequestBuilder(startDate, endDate, notificationTypesToInclude);
        return this.blackDuckApiClient.getAllResponses(ApiDiscovery.NOTIFICATIONS_LINK_RESPONSE, requestBuilder);
    }

    public List<NotificationUserView> getFilteredUserNotifications(UserView user, Date startDate, Date endDate, List<String> notificationTypesToInclude) throws IntegrationException {
        BlackDuckRequestBuilder requestBuilder = this.prepareUserNotificationsRequest(user, startDate, endDate, notificationTypesToInclude);
        return this.blackDuckApiClient.getAllResponses(requestBuilder, NotificationUserView.class);
    }

    public Date getLatestNotificationDate() throws IntegrationException {
        BlackDuckRequestBuilder requestBuilder = this.createLatestDateRequestBuilder();
        List notifications = this.blackDuckApiClient.getSomeResponses(ApiDiscovery.NOTIFICATIONS_LINK_RESPONSE, requestBuilder, 1);
        return this.getFirstCreatedAtDate(notifications);
    }

    public Date getLatestUserNotificationDate(UserView userView) throws IntegrationException {
        BlackDuckRequestBuilder requestBuilder = this.createLatestDateRequestBuilder();
        List userNotifications = this.blackDuckApiClient.getSomeResponses((BlackDuckView)userView, UserView.NOTIFICATIONS_LINK_RESPONSE, requestBuilder, 1);
        return this.getFirstCreatedAtDate(userNotifications);
    }

    private Date getFirstCreatedAtDate(List<? extends NotificationViewData> notifications) {
        if (notifications.size() == 1) {
            return notifications.get(0).getCreatedAt();
        }
        return new Date();
    }

    private BlackDuckRequestBuilder prepareUserNotificationsRequest(UserView user, Date startDate, Date endDate, List<String> notificationTypesToInclude) throws IntegrationException {
        HttpUrl url = user.getFirstLink("notifications");
        return this.createNotificationRequestBuilder(startDate, endDate, notificationTypesToInclude).url(url);
    }

    private BlackDuckRequestBuilder createLatestDateRequestBuilder() {
        return this.blackDuckRequestFactory.createCommonGetRequestBuilder().addBlackDuckFilter(this.createFilterForAllKnownTypes());
    }

    private List<String> getAllKnownNotificationTypes() {
        List<String> allKnownTypes = Stream.of(NotificationType.values()).map(Enum::name).collect(Collectors.toList());
        return allKnownTypes;
    }

    private BlackDuckRequestFilter createFilterForAllKnownTypes() {
        return this.createFilterForSpecificTypes(this.getAllKnownNotificationTypes());
    }

    private BlackDuckRequestFilter createFilterForSpecificTypes(List<String> notificationTypesToInclude) {
        return BlackDuckRequestFilter.createFilterWithMultipleValues("notificationType", notificationTypesToInclude);
    }

    private BlackDuckRequestBuilder createNotificationRequestBuilder(Date startDate, Date endDate, List<String> notificationTypesToInclude) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String startDateString = sdf.format(startDate);
        String endDateString = sdf.format(endDate);
        BlackDuckRequestFilter notificationTypeFilter = this.createFilterForSpecificTypes(notificationTypesToInclude);
        return this.blackDuckRequestFactory.createCommonGetRequestBuilder().addQueryParameter("startDate", startDateString).addQueryParameter("endDate", endDateString).addBlackDuckFilter(notificationTypeFilter);
    }
}

