/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.dataservice;

import com.synopsys.integration.blackduck.api.core.BlackDuckComponent;
import com.synopsys.integration.blackduck.api.core.BlackDuckView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.manual.view.ProjectMappingView;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import java.util.List;

public class ProjectMappingService
extends DataService {
    public ProjectMappingService(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger) {
        super(blackDuckApiClient, blackDuckRequestFactory, logger);
    }

    public void populateApplicationId(ProjectView projectView, String applicationId) throws IntegrationException {
        List projectMappings = this.blackDuckApiClient.getAllResponses((BlackDuckView)projectView, ProjectView.PROJECT_MAPPINGS_LINK_RESPONSE);
        boolean canCreate = projectMappings.isEmpty();
        if (canCreate) {
            if (!projectView.hasLink("project-mappings")) {
                throw new BlackDuckIntegrationException(String.format("The supplied projectView does not have the link (%s) to create a project mapping.", "project-mappings"));
            }
            HttpUrl projectMappingsLink = projectView.getFirstLink("project-mappings");
            ProjectMappingView projectMappingView = new ProjectMappingView();
            projectMappingView.setApplicationId(applicationId);
            this.blackDuckApiClient.post(projectMappingsLink, (BlackDuckComponent)projectMappingView);
        } else {
            ProjectMappingView projectMappingView = (ProjectMappingView)projectMappings.get(0);
            projectMappingView.setApplicationId(applicationId);
            this.blackDuckApiClient.put((BlackDuckView)projectMappingView);
        }
    }

    public List<ProjectMappingView> getProjectMappings(ProjectView projectView) throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses((BlackDuckView)projectView, ProjectView.PROJECT_MAPPINGS_LINK_RESPONSE);
    }
}

