/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.dataservice;

import com.synopsys.integration.blackduck.api.core.BlackDuckComponent;
import com.synopsys.integration.blackduck.api.core.BlackDuckView;
import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.manual.temporary.component.ProjectRequest;
import com.synopsys.integration.blackduck.api.manual.temporary.component.ProjectVersionRequest;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.dataservice.ProjectGetService;
import com.synopsys.integration.blackduck.service.model.ProjectSyncModel;
import com.synopsys.integration.blackduck.service.model.ProjectVersionWrapper;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.util.NameVersion;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class ProjectService
extends DataService {
    private final ProjectGetService projectGetService;

    public ProjectService(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger, ProjectGetService projectGetService) {
        super(blackDuckApiClient, blackDuckRequestFactory, logger);
        this.projectGetService = projectGetService;
    }

    public List<ProjectView> getAllProjects() throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(ApiDiscovery.PROJECTS_LINK_RESPONSE);
    }

    public ProjectVersionWrapper createProject(ProjectRequest projectRequest) throws IntegrationException {
        HttpUrl projectUrl = this.blackDuckApiClient.post(ApiDiscovery.PROJECTS_LINK, (BlackDuckComponent)projectRequest);
        ProjectView projectView = this.blackDuckApiClient.getResponse(projectUrl, ProjectView.class);
        if (null == projectRequest.getVersionRequest()) {
            return new ProjectVersionWrapper(projectView);
        }
        Optional<ProjectVersionView> projectVersionView = this.getProjectVersion(projectView, projectRequest.getVersionRequest().getVersionName());
        return new ProjectVersionWrapper(projectView, projectVersionView.orElse(null));
    }

    public List<ProjectVersionView> getAllProjectVersions(ProjectView projectView) throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses((BlackDuckView)projectView, ProjectView.VERSIONS_LINK_RESPONSE);
    }

    public ProjectVersionView createProjectVersion(ProjectView projectView, ProjectVersionRequest projectVersionRequest) throws IntegrationException {
        if (!projectView.hasLink("versions")) {
            throw new BlackDuckIntegrationException(String.format("The supplied projectView does not have the link (%s) to create a version.", "versions"));
        }
        HttpUrl projectVersionUrl = this.blackDuckApiClient.post(projectView.getFirstLink("versions"), (BlackDuckComponent)projectVersionRequest);
        return this.blackDuckApiClient.getResponse(projectVersionUrl, ProjectVersionView.class);
    }

    public List<ProjectView> getAllProjectMatches(String projectName) throws IntegrationException {
        return this.projectGetService.getAllProjectMatches(projectName);
    }

    public List<ProjectView> getProjectMatches(String projectName, int limit) throws IntegrationException {
        return this.projectGetService.getProjectMatches(projectName, limit);
    }

    public Optional<ProjectView> getProjectByName(String projectName) throws IntegrationException {
        return this.projectGetService.getProjectViewByProjectName(projectName);
    }

    public Optional<ProjectVersionView> getProjectVersion(ProjectView project, String projectVersionName) throws IntegrationException {
        return this.projectGetService.getProjectVersionViewByProjectVersionName(project, projectVersionName);
    }

    public Optional<ProjectVersionWrapper> getProjectVersion(NameVersion projectAndVersion) throws IntegrationException {
        return this.getProjectVersion(projectAndVersion.getName(), projectAndVersion.getVersion());
    }

    public Optional<ProjectVersionWrapper> getProjectVersion(String projectName, String projectVersionName) throws IntegrationException {
        Optional<ProjectVersionView> projectVersionView;
        Optional<ProjectView> projectView = this.getProjectByName(projectName);
        if (projectView.isPresent() && (projectVersionView = this.getProjectVersion(projectView.get(), projectVersionName)).isPresent()) {
            return Optional.of(new ProjectVersionWrapper(projectView.get(), projectVersionView.get()));
        }
        return Optional.empty();
    }

    public Optional<ProjectVersionView> getNewestProjectVersion(ProjectView projectView) throws IntegrationException {
        List<ProjectVersionView> projectVersionViews = this.getAllProjectVersions(projectView);
        return projectVersionViews.stream().max(Comparator.comparing(ProjectVersionView::getCreatedAt));
    }

    public void updateProject(ProjectView projectView) throws IntegrationException {
        this.blackDuckApiClient.put((BlackDuckView)projectView);
    }

    public void updateProjectVersion(ProjectVersionView projectVersionView) throws IntegrationException {
        this.blackDuckApiClient.put((BlackDuckView)projectVersionView);
    }

    public ProjectVersionWrapper syncProjectAndVersion(ProjectSyncModel projectSyncModel) throws IntegrationException {
        return this.syncProjectAndVersion(projectSyncModel, false);
    }

    public ProjectVersionWrapper syncProjectAndVersion(ProjectSyncModel projectSyncModel, boolean performUpdate) throws IntegrationException {
        String projectName = projectSyncModel.getName();
        Optional<ProjectView> optionalProjectView = this.getProjectByName(projectName);
        if (!optionalProjectView.isPresent()) {
            this.logger.info(String.format("The %s project was not found, so it will be created - if a version was included, it will also be created.", projectName));
            ProjectRequest projectRequest = projectSyncModel.createProjectRequest();
            return this.createProject(projectRequest);
        }
        ProjectView projectView = optionalProjectView.get();
        if (performUpdate) {
            this.logger.info(String.format("The %s project was found and performUpdate=true, so it will be updated.", projectName));
            projectSyncModel.populateProjectView(projectView);
            this.blackDuckApiClient.put((BlackDuckView)projectView);
            projectView = this.blackDuckApiClient.getResponse(projectView.getHref(), ProjectView.class);
        }
        ProjectVersionView projectVersionView = null;
        if (projectSyncModel.shouldHandleProjectVersion()) {
            String projectVersionName = projectSyncModel.getVersionName();
            Optional<ProjectVersionView> optionalProjectVersionView = this.getProjectVersion(projectView, projectVersionName);
            if (optionalProjectVersionView.isPresent()) {
                projectVersionView = optionalProjectVersionView.get();
                if (performUpdate) {
                    this.logger.info(String.format("The %s version was found and performUpdate=true, so the version will be updated.", projectVersionName));
                    projectSyncModel.populateProjectVersionView(projectVersionView);
                    this.blackDuckApiClient.put((BlackDuckView)projectVersionView);
                    projectVersionView = this.blackDuckApiClient.getResponse(projectVersionView.getHref(), ProjectVersionView.class);
                }
            } else {
                this.logger.info(String.format("The %s version was not found, so it will be created under the %s project.", projectVersionName, projectName));
                ProjectVersionRequest projectVersionRequest = projectSyncModel.createProjectVersionRequest();
                projectVersionView = this.createProjectVersion(projectView, projectVersionRequest);
            }
        }
        return new ProjectVersionWrapper(projectView, projectVersionView);
    }
}

