/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.generated.view.RiskProfileView;
import com.synopsys.integration.blackduck.service.model.BomRiskCounts;
import com.synopsys.integration.blackduck.service.model.PolicyRule;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class BomComponent {
    private String policyStatus;
    private List<PolicyRule> policyRulesViolated;
    private String componentName;
    private String componentURL;
    private String componentVersion;
    private String componentVersionURL;
    private String license;
    private BomRiskCounts securityRiskCounts = new BomRiskCounts();
    private BomRiskCounts licenseRiskCounts = new BomRiskCounts();
    private BomRiskCounts operationalRiskCounts = new BomRiskCounts();

    public void addSecurityRiskProfile(RiskProfileView securityRiskProfile) {
        this.addRiskProfile(securityRiskProfile, this.securityRiskCounts);
    }

    public void addLicenseRiskProfile(RiskProfileView licenseRiskProfile) {
        this.addRiskProfile(licenseRiskProfile, this.licenseRiskCounts);
    }

    public void addOperationalRiskProfile(RiskProfileView operationalRiskProfile) {
        this.addRiskProfile(operationalRiskProfile, this.operationalRiskCounts);
    }

    private void addRiskProfile(RiskProfileView riskProfileView, BomRiskCounts bomRiskCounts) {
        if (null == riskProfileView || CollectionUtils.isEmpty((Collection)riskProfileView.getCounts())) {
            return;
        }
        riskProfileView.getCounts().stream().forEach(bomRiskCounts::add);
    }

    public String getPolicyStatus() {
        return this.policyStatus;
    }

    public void setPolicyStatus(String policyStatus) {
        this.policyStatus = policyStatus;
    }

    public List<PolicyRule> getPolicyRulesViolated() {
        return this.policyRulesViolated;
    }

    public void setPolicyRulesViolated(List<PolicyRule> policyRulesViolated) {
        this.policyRulesViolated = policyRulesViolated;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentURL() {
        return this.componentURL;
    }

    public void setComponentURL(String componentURL) {
        this.componentURL = componentURL;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
    }

    public String getComponentVersionURL() {
        return this.componentVersionURL;
    }

    public void setComponentVersionURL(String componentVersionURL) {
        this.componentVersionURL = componentVersionURL;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public int getSecurityRiskHighCount() {
        return this.securityRiskCounts.getHigh();
    }

    public int getSecurityRiskMediumCount() {
        return this.securityRiskCounts.getMedium();
    }

    public int getSecurityRiskLowCount() {
        return this.securityRiskCounts.getLow();
    }

    public int getLicenseRiskHighCount() {
        return this.licenseRiskCounts.getHigh();
    }

    public int getLicenseRiskMediumCount() {
        return this.licenseRiskCounts.getMedium();
    }

    public int getLicenseRiskLowCount() {
        return this.licenseRiskCounts.getLow();
    }

    public int getOperationalRiskHighCount() {
        return this.operationalRiskCounts.getHigh();
    }

    public int getOperationalRiskMediumCount() {
        return this.operationalRiskCounts.getMedium();
    }

    public int getOperationalRiskLowCount() {
        return this.operationalRiskCounts.getLow();
    }

    public BomRiskCounts getSecurityRiskCounts() {
        return this.securityRiskCounts;
    }

    public BomRiskCounts getLicenseRiskCounts() {
        return this.licenseRiskCounts;
    }

    public BomRiskCounts getOperationalRiskCounts() {
        return this.operationalRiskCounts;
    }
}

