/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.service.model.ProjectNameVersionGuess;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ProjectNameVersionGuesser {
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public ProjectNameVersionGuess guessNameAndVersion(String fullString) {
        String guessedName = "";
        String guessedVersion = "";
        int index = -1;
        if (fullString.contains("-")) {
            index = this.findIndexBeforeNumeric(fullString, "-", 0);
        } else if (fullString.contains(".")) {
            index = this.findIndexBeforeNumeric(fullString, ".", 0);
        }
        if (index > 0) {
            guessedName = fullString.substring(0, index);
            guessedVersion = fullString.substring(index + 1);
        }
        if (StringUtils.isBlank((CharSequence)guessedName) || StringUtils.isBlank((CharSequence)guessedVersion)) {
            guessedName = fullString;
            guessedVersion = this.getDefaultVersionGuess();
        }
        return new ProjectNameVersionGuess(guessedName, guessedVersion);
    }

    public String getDefaultVersionGuess() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        String defaultVersionGuess = simpleDateFormat.format(new Date());
        return defaultVersionGuess;
    }

    private int findIndexBeforeNumeric(String fullString, String separator, int fromIndex) {
        int index = fullString.indexOf(separator, fromIndex);
        if (index == -1) {
            return -1;
        }
        if (index + 1 < fullString.length() && StringUtils.isNumeric((CharSequence)fullString.substring(index + 1, index + 2))) {
            return index;
        }
        return this.findIndexBeforeNumeric(fullString, separator, index + 1);
    }
}

