/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model.pdf;

import com.synopsys.integration.blackduck.exception.RiskReportException;
import com.synopsys.integration.blackduck.service.model.BomComponent;
import com.synopsys.integration.blackduck.service.model.ReportData;
import com.synopsys.integration.blackduck.service.model.pdf.FontLoader;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.pdf.PDFBoxManager;
import com.synopsys.integration.pdf.StringManager;
import com.synopsys.integration.util.IntegrationEscapeUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class RiskReportPdfWriter {
    public static String BASIC_RED = "#b52b24";
    public static String SALMON_RED = "#eca4a0";
    private String HIGH_RISK = "High Risk";
    private String MED_RISK = "Medium Risk";
    private String LOW_RISK = "Low Risk";
    private String NO_RISK = "No Risk";
    private IntLogger logger;
    private FontLoader fontLoader;
    private FontLoader boldFontLoader;
    private Color textColor;
    private float fontSize;
    private PDFBoxManager pdfManager;
    private PDFont font;
    private PDFont boldFont;

    public RiskReportPdfWriter(IntLogger logger) {
        this(logger, document -> PDType1Font.HELVETICA, document -> PDType1Font.HELVETICA_BOLD, Color.BLACK, 10.0f);
    }

    public RiskReportPdfWriter(IntLogger logger, FontLoader fontLoader, FontLoader boldFontLoader, Color textColor, float fontSize) {
        this.logger = logger;
        this.fontLoader = fontLoader;
        this.boldFontLoader = boldFontLoader;
        this.textColor = textColor;
        this.fontSize = fontSize;
    }

    public File createPDFReportFile(File outputDirectory, ReportData report) throws RiskReportException {
        File file;
        IntegrationEscapeUtil escapeUtil = new IntegrationEscapeUtil();
        String escapedProjectName = escapeUtil.replaceWithUnderscore(report.getProjectName());
        String escapedProjectVersionName = escapeUtil.replaceWithUnderscore(report.getProjectVersion());
        File pdfFile = new File(outputDirectory, escapedProjectName + "_" + escapedProjectVersionName + "_BlackDuck_RiskReport.pdf");
        if (pdfFile.exists()) {
            pdfFile.delete();
        }
        PDDocument document = new PDDocument();
        this.font = this.fontLoader.loadFont(document);
        this.boldFont = this.boldFontLoader.loadFont(document);
        document.getDocumentInformation().setAuthor("Black Duck Software");
        document.getDocumentInformation().setCreator("Integrations");
        document.getDocumentInformation().setSubject("Black Duck Risk Report");
        PDFBoxManager pdfManager = new PDFBoxManager(pdfFile, document);
        try {
            this.pdfManager = pdfManager;
            PDRectangle pageBox = pdfManager.currentPage.getMediaBox();
            float pageWidth = pageBox.getWidth();
            float pageHeight = pageBox.getHeight();
            PDRectangle headerRectangle = this.writeHeader(pageWidth, pageHeight);
            PDRectangle dateTimeRectangle = this.writeDateTime(headerRectangle.getLowerLeftY(), report.getDateTimeOfLatestScan().orElse(null));
            PDRectangle bottomOfProjectInfoRectangle = this.writeProjectInformation(pageWidth, dateTimeRectangle.getLowerLeftY(), report);
            PDRectangle bottomOfSummaryTableRectangle = this.writeSummaryTables(pageWidth, bottomOfProjectInfoRectangle.getLowerLeftY(), report);
            PDRectangle bottomOfComponentTableRectangle = this.writeComponentTable(pageWidth, bottomOfSummaryTableRectangle.getLowerLeftY(), report);
            file = pdfFile;
        }
        catch (Throwable pageBox) {
            try {
                try {
                    pdfManager.close();
                }
                catch (Throwable throwable) {
                    pageBox.addSuppressed(throwable);
                }
                throw pageBox;
            }
            catch (IOException | URISyntaxException e) {
                String errorString = "Couldn't create the report: ";
                this.logger.trace(errorString + e.getMessage(), (Throwable)e);
                throw new RiskReportException(errorString + e.getMessage(), e);
            }
        }
        pdfManager.close();
        return file;
    }

    private PDRectangle writeHeader(float pageWidth, float startingHeight) throws IOException, URISyntaxException {
        PDRectangle logoRectangle = this.pdfManager.drawRectangle(0.0f, startingHeight - 100.0f, pageWidth, 100.0f, Color.WHITE);
        this.pdfManager.drawImage(30.0f, logoRectangle.getLowerLeftY() + 27.5f, 203.0f, 45.0f, "/riskreport/web/images/Synopsys_logo.png");
        PDRectangle titleRectangle = this.pdfManager.drawRectangle(0.0f, logoRectangle.getLowerLeftY() - 80.0f, pageWidth - 35.0f, 80.0f, new Color(110, 50, 155).darker());
        this.pdfManager.writeText(35.0f, titleRectangle.getLowerLeftY() + 32.0f, "Black Duck Risk Report", this.boldFont, 20.0f, Color.WHITE);
        this.logger.trace("Finished writing the pdf header.");
        return titleRectangle;
    }

    private PDRectangle writeDateTime(float startingHeight, LocalDateTime dateTimeOfLatestScan) throws IOException {
        String formattedDateTimeString = dateTimeOfLatestScan != null ? dateTimeOfLatestScan.format(DateTimeFormatter.ofPattern("MM/dd/yyyy - HH:mm:ss")).replace("-", "at") : "N/A";
        return this.pdfManager.writeText(5.0f, startingHeight - 10.0f, String.format("Latest scan: %s.", formattedDateTimeString), (PDFont)PDType1Font.TIMES_ITALIC, 8.0f, Color.BLACK);
    }

    private PDRectangle writeProjectInformation(float pageWidth, float startingHeight, ReportData reportData) throws IOException {
        float height = startingHeight - 40.0f;
        PDRectangle rectangle = this.pdfManager.writeWrappedLink(5.0f, height, 280.0f, reportData.getProjectName(), reportData.getProjectURL(), this.font, 18.0f);
        String dash = " - ";
        rectangle = this.pdfManager.writeText(5.0f + rectangle.getUpperRightX(), height, dash, this.font, 18.0f, Color.BLACK);
        rectangle = this.pdfManager.writeWrappedLink(5.0f + rectangle.getUpperRightX(), height, 280.0f - rectangle.getWidth(), reportData.getProjectVersion(), reportData.getProjectVersionURL(), this.font, 18.0f);
        String projectAttributesString = "Phase:  " + reportData.getPhase() + "    |    Distribution:  " + reportData.getDistribution();
        rectangle = this.pdfManager.writeWrappedText(5.0f, rectangle.getLowerLeftY() - 40.0f, 300.0f, projectAttributesString, this.font, this.fontSize, this.textColor);
        this.logger.trace("Finished writing the project information.");
        return rectangle;
    }

    private PDRectangle writeSummaryTables(float pageWidth, float startingHeight, ReportData reportData) throws IOException {
        float center = pageWidth / 2.0f;
        float height = startingHeight - 40.0f;
        this.writeSummaryTable(center - 180.0f, height, "Security Risk", reportData.getVulnerabilityRiskHighCount(), reportData.getVulnerabilityRiskMediumCount(), reportData.getVulnerabilityRiskLowCount(), reportData.getVulnerabilityRiskNoneCount(), reportData.getTotalComponents());
        this.writeSummaryTable(center, height, "License Risk", reportData.getLicenseRiskHighCount(), reportData.getLicenseRiskMediumCount(), reportData.getLicenseRiskLowCount(), reportData.getLicenseRiskNoneCount(), reportData.getTotalComponents());
        PDRectangle rectangle = this.writeSummaryTable(center + 180.0f, height, "Operational Risk", reportData.getOperationalRiskHighCount(), reportData.getOperationalRiskMediumCount(), reportData.getOperationalRiskLowCount(), reportData.getOperationalRiskNoneCount(), reportData.getTotalComponents());
        this.logger.trace("Finished writing the summary tables.");
        return rectangle;
    }

    private PDRectangle writeSummaryTable(float centerX, float y, String title, int highCount, int mediumCount, int lowCount, int noneCount, int totalCount) throws IOException {
        PDRectangle rectangle = this.pdfManager.writeTextCentered(centerX, y, title, this.boldFont, 14.0f, Color.BLACK);
        rectangle = this.writeSummaryTableRow(centerX, rectangle.getLowerLeftY() - 14.0f, this.HIGH_RISK, highCount, totalCount, Color.decode(BASIC_RED));
        rectangle = this.writeSummaryTableRow(centerX, rectangle.getLowerLeftY() - 14.0f, this.MED_RISK, mediumCount, totalCount, Color.decode(SALMON_RED));
        rectangle = this.writeSummaryTableRow(centerX, rectangle.getLowerLeftY() - 14.0f, this.LOW_RISK, lowCount, totalCount, new Color(153, 153, 153));
        return this.writeSummaryTableRow(centerX, rectangle.getLowerLeftY() - 14.0f, this.NO_RISK, noneCount, totalCount, new Color(221, 221, 221));
    }

    private PDRectangle writeSummaryTableRow(float centerX, float rowY, String rowTitle, int count, float totalCount, Color barColor) throws IOException {
        float rowTitleX = centerX - 80.0f;
        PDRectangle rectangle = this.pdfManager.writeText(rowTitleX, rowY, rowTitle, this.font, this.fontSize, this.textColor);
        String countString = String.valueOf(count);
        this.pdfManager.writeTextCentered(centerX, rowY, countString, this.font, this.fontSize, this.textColor);
        float barX = centerX + 20.0f;
        if (count > 0) {
            this.pdfManager.drawRectangle(barX, rowY, (float)count / totalCount * 60.0f, 10.0f, barColor);
        }
        return rectangle;
    }

    private PDRectangle writeComponentTable(float pageWidth, float startingHeight, ReportData reportData) throws IOException, URISyntaxException {
        float height = startingHeight - 40.0f;
        PDRectangle rectangle = this.pdfManager.writeText(30.0f, height, "BOM Entries " + reportData.getTotalComponents(), this.font, this.fontSize, this.textColor);
        PDRectangle rowRectangle = this.pdfManager.drawRectangle(10.0f, rectangle.getLowerLeftY() - 22.0f, pageWidth - 20.0f, 18.0f, new Color(221, 221, 221));
        float rowY = rowRectangle.getLowerLeftY() + 5.0f;
        this.pdfManager.writeText(50.0f, rowY, "Component", this.boldFont, 12.0f, this.textColor);
        this.pdfManager.writeText(190.0f, rowY, "Version", this.boldFont, 12.0f, this.textColor);
        this.pdfManager.writeText(310.0f, rowY, "License", this.boldFont, 12.0f, this.textColor);
        this.pdfManager.writeText(430.0f, rowY, "H", this.boldFont, 12.0f, this.textColor);
        this.pdfManager.writeText(470.0f, rowY, "M", this.boldFont, 12.0f, this.textColor);
        this.pdfManager.writeText(510.0f, rowY, "L", this.boldFont, 12.0f, this.textColor);
        this.pdfManager.writeText(550.0f, rowY, "Opt R", this.boldFont, 12.0f, this.textColor);
        boolean isOdd = false;
        for (BomComponent component : reportData.getComponents()) {
            if (null == component) continue;
            rowRectangle = this.writeComponentRow(pageWidth, rowRectangle.getLowerLeftY(), component, isOdd);
            isOdd = !isOdd;
        }
        this.logger.trace("Finished writing the component table.");
        return rowRectangle;
    }

    private PDRectangle writeComponentRow(float pageWidth, float y, BomComponent component, boolean isOdd) throws IOException, URISyntaxException {
        float componentNameWidth = 125.0f;
        float componentVersionWidth = 115.0f;
        float componentLicenseWidth = 150.0f;
        List componentNameTextLines = new ArrayList();
        List componentVersionTextLines = new ArrayList();
        List componentLicenseTextLines = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)component.getComponentName())) {
            componentNameTextLines = StringManager.wrapToCombinedList((PDFont)this.font, (float)this.fontSize, (String)component.getComponentName(), (float)Math.round(componentNameWidth));
        }
        if (StringUtils.isNotBlank((CharSequence)component.getComponentVersion())) {
            componentVersionTextLines = StringManager.wrapToCombinedList((PDFont)this.font, (float)this.fontSize, (String)component.getComponentVersion(), (float)Math.round(componentNameWidth));
        }
        if (StringUtils.isNotBlank((CharSequence)component.getLicense())) {
            componentLicenseTextLines = StringManager.wrapToCombinedList((PDFont)this.font, (float)this.fontSize, (String)component.getLicense(), (float)Math.round(componentNameWidth));
        }
        float rowHeight = this.pdfManager.getApproximateWrappedStringHeight(componentNameTextLines.size(), this.fontSize);
        float componentVersionHeight = this.pdfManager.getApproximateWrappedStringHeight(componentVersionTextLines.size(), this.fontSize);
        float componentLicenseHeight = this.pdfManager.getApproximateWrappedStringHeight(componentLicenseTextLines.size(), this.fontSize);
        if (componentVersionHeight > rowHeight) {
            rowHeight = componentVersionHeight;
        }
        if (componentLicenseHeight > rowHeight) {
            rowHeight = componentLicenseHeight;
        }
        PDRectangle rowRectangle = null;
        Color rowColor = Color.WHITE;
        if (isOdd) {
            rowColor = new Color(221, 221, 221);
            rowRectangle = this.pdfManager.drawRectangle(10.0f, y - rowHeight, pageWidth - 20.0f, rowHeight, rowColor);
        } else {
            rowRectangle = this.pdfManager.drawRectangle(10.0f, y - rowHeight, pageWidth - 20.0f, rowHeight, rowColor);
        }
        float rowUpperY = rowRectangle.getUpperRightY();
        if (StringUtils.isNotBlank((CharSequence)component.getPolicyStatus()) && component.getPolicyStatus().equalsIgnoreCase("IN_VIOLATION")) {
            this.pdfManager.drawImageCentered(15.0f, rowUpperY, 8.0f, 8.0f, 0.0f, rowHeight, "/riskreport/web/images/cross_through_circle.png");
        }
        String componentURL = "";
        if (StringUtils.isNotBlank((CharSequence)component.getComponentURL())) {
            componentURL = component.getComponentURL();
        }
        String componentVersionURL = "";
        if (StringUtils.isNotBlank((CharSequence)component.getComponentVersionURL())) {
            componentVersionURL = component.getComponentVersionURL();
        }
        this.pdfManager.writeWrappedVerticalCenteredLink(30.0f, rowUpperY, componentNameWidth, rowHeight, componentNameTextLines, componentURL, this.font, this.fontSize, this.textColor);
        this.pdfManager.writeWrappedCenteredLink(210.0f, rowUpperY, componentVersionWidth, rowHeight, componentVersionTextLines, componentVersionURL, this.font, this.fontSize, this.textColor);
        Risk licenseRisk = this.getLicenseRisk(component, rowColor);
        if (StringUtils.isNotBlank((CharSequence)licenseRisk.riskShortString)) {
            this.pdfManager.drawRectangleCentered(282.0f, rowUpperY - 1.0f, 12.0f, 12.0f, rowHeight, licenseRisk.riskColor);
            this.pdfManager.writeTextCentered(282.0f, rowUpperY, rowHeight, licenseRisk.riskShortString, this.font, this.fontSize, this.textColor);
        }
        this.pdfManager.writeWrappedVerticalCenteredText(290.0f, rowUpperY, componentLicenseWidth, rowHeight, componentLicenseTextLines, this.font, this.fontSize, this.textColor);
        this.pdfManager.writeTextCentered(434.0f, rowUpperY, rowHeight, String.valueOf(component.getSecurityRiskHighCount()), this.font, this.fontSize, this.textColor);
        this.pdfManager.writeTextCentered(477.0f, rowUpperY, rowHeight, String.valueOf(component.getSecurityRiskMediumCount()), this.font, this.fontSize, this.textColor);
        this.pdfManager.writeTextCentered(520.0f, rowUpperY, rowHeight, String.valueOf(component.getSecurityRiskLowCount()), this.font, this.fontSize, this.textColor);
        Risk operationalRisk = this.getOperationalRisk(component, rowColor);
        this.pdfManager.drawRectangle(545.0f, rowRectangle.getLowerLeftY(), 60.0f, rowHeight, operationalRisk.riskColor);
        this.pdfManager.writeTextCentered(575.0f, rowUpperY, rowHeight, operationalRisk.riskShortString, this.boldFont, 12.0f, this.textColor);
        return rowRectangle;
    }

    public Risk getLicenseRisk(BomComponent component, Color noColor) {
        Risk risk = new Risk();
        risk.riskShortString = "";
        risk.riskColor = noColor;
        if (component.getLicenseRiskHighCount() > 0) {
            risk.riskShortString = "H";
            risk.riskColor = Color.decode(BASIC_RED);
        } else if (component.getLicenseRiskMediumCount() > 0) {
            risk.riskShortString = "M";
            risk.riskColor = Color.decode(SALMON_RED);
        } else if (component.getLicenseRiskLowCount() > 0) {
            risk.riskShortString = "L";
            risk.riskColor = new Color(153, 153, 153);
        }
        return risk;
    }

    public Risk getOperationalRisk(BomComponent component, Color noColor) {
        Risk risk = new Risk();
        risk.riskShortString = "-";
        risk.riskColor = noColor;
        if (component.getOperationalRiskHighCount() > 0) {
            risk.riskShortString = "H";
            risk.riskColor = Color.decode(BASIC_RED);
        } else if (component.getOperationalRiskMediumCount() > 0) {
            risk.riskShortString = "M";
            risk.riskColor = Color.decode(SALMON_RED);
        } else if (component.getOperationalRiskLowCount() > 0) {
            risk.riskShortString = "L";
            risk.riskColor = new Color(153, 153, 153);
        }
        return risk;
    }

    private class Risk {
        public String riskShortString;
        public Color riskColor;

        private Risk() {
        }
    }
}

