/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.jvm;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import com.tqdev.metrics.core.MetricRegistry;
import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;

public class SystemMonitor {
    final MetricRegistry registry;

    public SystemMonitor(MetricRegistry registry) {
        this.registry = registry;
        this.registerOsStatistics();
        this.registerRuntimeMemory();
        this.registerGarbageCollectionStatistics();
        this.registerMemoryStatistics();
        this.registerDiskStatistics();
        this.registerThreadStatistics();
    }

    private void registerOsStatistics() {
        java.lang.management.OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        this.registry.set("jvm.Os.Cpu", "load", () -> Math.round(os.getSystemLoadAverage() * 100.0));
        try {
            OperatingSystemMXBean sun = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            this.registry.set("jvm.Os.Cpu", "process", () -> Math.round(sun.getProcessCpuLoad() * 100.0));
            this.registry.set("jvm.Os.Cpu", "system", () -> Math.round(sun.getSystemCpuLoad() * 100.0));
            this.registry.set("jvm.Os.Memory", "free", () -> sun.getFreePhysicalMemorySize());
            this.registry.set("jvm.Os.Memory", "total", () -> sun.getTotalPhysicalMemorySize());
            this.registry.set("jvm.Os.Swap", "free", () -> sun.getFreeSwapSpaceSize());
            this.registry.set("jvm.Os.Swap", "total", () -> sun.getTotalSwapSpaceSize());
        }
        catch (Exception sun) {
            // empty catch block
        }
        try {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            this.registry.set("jvm.Os.FileDescriptors", "open", () -> unix.getOpenFileDescriptorCount());
            this.registry.set("jvm.Os.FileDescriptors", "max", () -> unix.getMaxFileDescriptorCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerRuntimeMemory() {
        this.registry.set("jvm.Memory.Runtime", "free", () -> Runtime.getRuntime().freeMemory());
        this.registry.set("jvm.Memory.Runtime", "total", () -> Runtime.getRuntime().totalMemory());
        this.registry.set("jvm.Memory.Runtime", "max", () -> {
            long max = Runtime.getRuntime().maxMemory();
            return max == Long.MAX_VALUE ? -1L : max;
        });
    }

    private void registerGarbageCollectionStatistics() {
        this.registry.set("jvm.Memory.GarbageCollection", "count", () -> {
            long total = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = gc.getCollectionCount();
                if (count < 0L) continue;
                total += count;
            }
            return total;
        });
        this.registry.set("jvm.Memory.GarbageCollection", "time", () -> {
            long total = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = gc.getCollectionTime();
                if (count < 0L) continue;
                total += count;
            }
            return total;
        });
        this.registry.set("jvm.Memory.GarbageCollection", "uptime", () -> ManagementFactory.getRuntimeMXBean().getUptime());
    }

    private void registerMemoryStatistics() {
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        this.registry.set("jvm.Memory.Heap", "used", () -> mem.getHeapMemoryUsage().getUsed());
        this.registry.set("jvm.Memory.Heap", "init", () -> mem.getHeapMemoryUsage().getInit());
        this.registry.set("jvm.Memory.Heap", "max", () -> mem.getHeapMemoryUsage().getMax());
        this.registry.set("jvm.Memory.Heap", "comitted", () -> mem.getHeapMemoryUsage().getCommitted());
        this.registry.set("jvm.Memory.NonHeap", "used", () -> mem.getNonHeapMemoryUsage().getUsed());
        this.registry.set("jvm.Memory.NonHeap", "init", () -> mem.getNonHeapMemoryUsage().getInit());
        this.registry.set("jvm.Memory.NonHeap", "max", () -> mem.getNonHeapMemoryUsage().getMax());
        this.registry.set("jvm.Memory.NonHeap", "comitted", () -> mem.getNonHeapMemoryUsage().getCommitted());
    }

    private void registerDiskStatistics() {
        for (File root : File.listRoots()) {
            long size;
            try {
                size = root.getTotalSpace();
            }
            catch (Exception e) {
                size = -1L;
            }
            if (size <= 0L) continue;
            this.registry.set("jvm.Disk.Free", root.getAbsolutePath(), () -> {
                try {
                    return root.getFreeSpace();
                }
                catch (Exception e) {
                    return -1L;
                }
            });
            this.registry.set("jvm.Disk.Total", root.getAbsolutePath(), () -> {
                try {
                    return root.getTotalSpace();
                }
                catch (Exception e) {
                    return -1L;
                }
            });
        }
    }

    private void registerThreadStatistics() {
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        this.registry.set("jvm.Thread.Count", "total", () -> thread.getThreadCount());
        this.registry.set("jvm.Thread.Count", "daemon", () -> thread.getDaemonThreadCount());
    }

    public Map<String, String> getSystemInformation() {
        java.lang.management.OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cpuCores", String.valueOf(Runtime.getRuntime().availableProcessors()));
        map.put("cpuArchitecture", os.getArch());
        map.put("osName", os.getName());
        map.put("osVersion", os.getVersion());
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        map.put("rtName", runtime.getName());
        map.put("vmName", runtime.getVmName());
        map.put("vmVendor", runtime.getVmVendor());
        map.put("vmVersion", runtime.getVmVersion());
        return map;
    }
}

