/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.service;

import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualMachineErrorTerminator {
    private static final int DEFAULT_VMERROR_EXIT_STATUS = -10;
    private static final Logger logger = Logger.getLogger(VirtualMachineErrorTerminator.class.getName());
    private static final Object lock = new Object();
    private static volatile boolean terminating = false;
    private static volatile VirtualMachineError terminationCause;
    private static volatile byte[] safetyBuffer;
    private static volatile int exitCode;
    private static Runnable exitInvoker;

    private static void startExitThread() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    while (!terminating) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    VirtualMachineErrorTerminator.access$302(null);
                    logger.log(Level.SEVERE, "Exiting JVM", terminationCause);
                    exitInvoker.run();
                }
            }
        }, "VirtualMachineErrorTerminator");
        t.setDaemon(true);
        t.setPriority(10);
        t.start();
    }

    private VirtualMachineErrorTerminator() {
    }

    public static void initialize() {
    }

    public static void setSafetyBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        safetyBuffer = null;
        safetyBuffer = new byte[size];
    }

    public static void setExitCode(int exitCode) {
        VirtualMachineErrorTerminator.exitCode = exitCode;
    }

    static void setExitInvoker(Runnable exitInvoker) {
        VirtualMachineErrorTerminator.exitInvoker = exitInvoker;
    }

    static void reset() {
        terminating = false;
        terminationCause = null;
        VirtualMachineErrorTerminator.startExitThread();
    }

    public static void checkTerminating() throws VirtualMachineError {
        if (terminating) {
            throw terminationCause;
        }
    }

    public static void terminateVMIfMust(Throwable t) {
        while (t != null) {
            if (t instanceof VirtualMachineError) {
                VirtualMachineErrorTerminator.terminateVM((VirtualMachineError)t);
            }
            t = t.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminateVM(VirtualMachineError e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        if (terminating) {
            return;
        }
        terminationCause = e;
        Object object = lock;
        synchronized (object) {
            terminating = true;
            lock.notify();
        }
    }

    static /* synthetic */ byte[] access$302(byte[] x0) {
        safetyBuffer = x0;
        return x0;
    }

    static {
        safetyBuffer = new byte[0x100000];
        exitCode = -10;
        VirtualMachineErrorTerminator.startExitThread();
        exitInvoker = new Runnable(){

            @Override
            public void run() {
                System.exit(exitCode);
            }
        };
    }
}

