/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import com.twitter.util.NetUtil$;
import java.net.Inet4Address;
import java.net.InetAddress;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetUtil$
implements ScalaObject {
    public static final NetUtil$ MODULE$;

    static {
        new NetUtil$();
    }

    public boolean isIpv4Address(String ip) {
        return this.ipToOptionInt(ip).isDefined();
    }

    public boolean isPrivateAddress(InetAddress ip) {
        Inet4Address inet4Address;
        Inet4Address ip2;
        byte[] addr;
        InetAddress inetAddress = ip;
        return inetAddress instanceof Inet4Address ? ((addr = (ip2 = (inet4Address = (Inet4Address)inetAddress)).getAddress())[0] == (byte)10 ? true : (addr[0] == (byte)172 && (addr[1] & 0xF0) == (byte)16 ? true : addr[0] == (byte)192 && addr[1] == (byte)168)) : false;
    }

    public int ipToInt(String ip) {
        return BoxesRunTime.unboxToInt((Object)this.ipToOptionInt(ip).getOrElse((Function0)new anonfun.ipToInt.1()));
    }

    public Option<Integer> ipToOptionInt(String ip) {
        int dot1 = ip.indexOf(46);
        if (dot1 <= 0) {
            return None$.MODULE$;
        }
        int dot2 = ip.indexOf(46, dot1 + 1);
        if (dot2 == -1) {
            return None$.MODULE$;
        }
        int dot3 = ip.indexOf(46, dot2 + 1);
        if (dot3 == -1) {
            return None$.MODULE$;
        }
        int num1 = this.ipv4DecimalToInt(ip.substring(0, dot1));
        if (num1 < 0) {
            return None$.MODULE$;
        }
        int num2 = this.ipv4DecimalToInt(ip.substring(dot1 + 1, dot2));
        if (num2 < 0) {
            return None$.MODULE$;
        }
        int num3 = this.ipv4DecimalToInt(ip.substring(dot2 + 1, dot3));
        if (num3 < 0) {
            return None$.MODULE$;
        }
        int num4 = this.ipv4DecimalToInt(ip.substring(dot3 + 1));
        if (num4 < 0) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)(num1 << 24 | num2 << 16 | num3 << 8 | num4)));
    }

    private int ipv4DecimalToInt(String s) {
        if (s.isEmpty() || s.length() > 3) {
            return -1;
        }
        int num = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                return -1;
            }
            num = num * 10 + (c - 48);
        }
        return num >= 0 && num <= 255 ? num : -1;
    }

    public int inetAddressToInt(InetAddress inetAddress) {
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress2 instanceof Inet4Address) {
            Inet4Address inet4Address;
            Inet4Address inetAddress3 = inet4Address = (Inet4Address)inetAddress2;
            byte[] addr = inetAddress3.getAddress();
            return (addr[0] & 0xFF) << 24 | (addr[1] & 0xFF) << 16 | (addr[2] & 0xFF) << 8 | addr[3] & 0xFF;
        }
        throw new IllegalArgumentException("non-Inet4Address cannot be converted to an Int");
    }

    public Tuple2<Integer, Integer> ipToIpBlock(String ip, Option<Integer> prefixLen) {
        int n;
        String[] arr$1;
        block2: {
            None$ t;
            block3: {
                None$ none$;
                block0: {
                    None$ none$2;
                    block1: {
                        arr$1 = Predef$.MODULE$.augmentString(ip).split('.');
                        none$ = prefixLen;
                        None$ none$3 = None$.MODULE$;
                        None$ none$4 = none$;
                        if (none$3 != null ? !none$3.equals(none$4) : none$4 != null) break block0;
                        none$2 = none$;
                        if (!this.gd1$1(arr$1)) break block1;
                        n = Predef$.MODULE$.refArrayOps((Object[])arr$1).size() * 8;
                        break block2;
                    }
                    t = none$2;
                    break block3;
                }
                t = none$;
            }
            n = BoxesRunTime.unboxToInt((Object)t.getOrElse((Function0)new anonfun.1()));
        }
        int pLen = n;
        int netIp = this.ipToInt(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arr$1).padTo(4, (Object)"0", Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).mkString("."));
        int mask = Integer.MIN_VALUE >> pLen - 1;
        return new Tuple2.mcII.sp(netIp, mask);
    }

    public Tuple2<Integer, Integer> cidrToIpBlock(String cidr) {
        String[] stringArray;
        block6: {
            Tuple2<Integer, Integer> tuple2;
            block5: {
                IndexedSeq indexedSeq;
                block4: {
                    stringArray = Predef$.MODULE$.augmentString(cidr).split('/');
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (option.isEmpty()) {
                        throw new MatchError((Object)stringArray);
                    }
                    indexedSeq = (IndexedSeq)option.get();
                    if (!(indexedSeq == null ? false : indexedSeq.lengthCompare(2) == 0)) break block4;
                    tuple2 = this.ipToIpBlock((String)indexedSeq.apply(0), (Option<Integer>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString((String)indexedSeq.apply(1)).toInt())));
                    break block5;
                }
                if (!(indexedSeq == null ? false : indexedSeq.lengthCompare(1) == 0)) break block6;
                tuple2 = this.ipToIpBlock((String)indexedSeq.apply(0), (Option<Integer>)None$.MODULE$);
            }
            return tuple2;
        }
        throw new MatchError((Object)stringArray);
    }

    public boolean isIpInBlock(int ip, Tuple2<Integer, Integer> ipBlock) {
        Tuple2<Integer, Integer> tuple2 = ipBlock;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        return (BoxesRunTime.unboxToInt((Object)tuple2._2()) & ip) == BoxesRunTime.unboxToInt((Object)tuple2._1());
    }

    public boolean isInetAddressInBlock(InetAddress inetAddress, Tuple2<Integer, Integer> ipBlock) {
        while (true) {
            // Infinite loop
        }
    }

    public boolean isIpInBlocks(int ip$1, Iterable<Tuple2<Integer, Integer>> ipBlocks) {
        return ipBlocks.exists((Function1)new anonfun.isIpInBlocks.1(ip$1));
    }

    public boolean isIpInBlocks(String ip, Iterable<Tuple2<Integer, Integer>> ipBlocks) {
        return this.isIpInBlocks(this.ipToInt(ip), ipBlocks);
    }

    public boolean isInetAddressInBlocks(InetAddress inetAddress, Iterable<Tuple2<Integer, Integer>> ipBlocks) {
        return this.isIpInBlocks(this.inetAddressToInt(inetAddress), ipBlocks);
    }

    private final /* synthetic */ boolean gd1$1(String[] stringArray) {
        return Predef$.MODULE$.refArrayOps((Object[])stringArray).size() != 4;
    }

    private NetUtil$() {
        MODULE$ = this;
    }
}

