/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UniquenessResponseControl
extends Control
implements DecodeableControl {
    public static final String UNIQUENESS_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.53";
    private static final byte TYPE_UNIQUENESS_ID = -128;
    private static final byte TYPE_PRE_COMMIT_VALIDATION_PASSED = -127;
    private static final byte TYPE_POST_COMMIT_VALIDATION_PASSED = -126;
    private static final byte TYPE_VALIDATION_MESSAGE = -125;
    private static final long serialVersionUID = 5090348902351420617L;
    private final Boolean postCommitValidationPassed;
    private final Boolean preCommitValidationPassed;
    private final String uniquenessID;
    private final String validationMessage;

    UniquenessResponseControl() {
        this.uniquenessID = null;
        this.preCommitValidationPassed = null;
        this.postCommitValidationPassed = null;
        this.validationMessage = null;
    }

    public UniquenessResponseControl(String uniquenessID, Boolean preCommitValidationPassed, Boolean postCommitValidationPassed, String validationMessage) {
        super(UNIQUENESS_RESPONSE_OID, false, UniquenessResponseControl.encodeValue(uniquenessID, preCommitValidationPassed, postCommitValidationPassed, validationMessage));
        Validator.ensureNotNull(uniquenessID);
        this.uniquenessID = uniquenessID;
        this.preCommitValidationPassed = preCommitValidationPassed;
        this.postCommitValidationPassed = postCommitValidationPassed;
        this.validationMessage = validationMessage;
    }

    private static ASN1OctetString encodeValue(String uniquenessID, Boolean preCommitValidationPassed, Boolean postCommitValidationPassed, String validationMessage) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        elements.add(new ASN1OctetString(-128, uniquenessID));
        if (preCommitValidationPassed != null) {
            elements.add(new ASN1Boolean(-127, preCommitValidationPassed));
        }
        if (postCommitValidationPassed != null) {
            elements.add(new ASN1Boolean(-126, postCommitValidationPassed));
        }
        if (validationMessage != null) {
            elements.add(new ASN1OctetString(-125, validationMessage));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public UniquenessResponseControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_DECODE_NO_VALUE.get());
        }
        try {
            String id = null;
            Boolean prePassed = null;
            Boolean postPassed = null;
            String message = null;
            block9: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        id = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    case -127: {
                        prePassed = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block9;
                    }
                    case -126: {
                        postPassed = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block9;
                    }
                    case -125: {
                        message = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_DECODE_UNKNOWN_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            if (id == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_DECODE_NO_UNIQUENESS_ID.get());
            }
            this.uniquenessID = id;
            this.preCommitValidationPassed = prePassed;
            this.postCommitValidationPassed = postPassed;
            this.validationMessage = message;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public UniquenessResponseControl decodeControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        return new UniquenessResponseControl(oid, isCritical, value);
    }

    public static Map<String, UniquenessResponseControl> get(LDAPResult result) throws LDAPException {
        Control[] responseControls = result.getResponseControls();
        if (responseControls.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, UniquenessResponseControl> controlMap = new LinkedHashMap<String, UniquenessResponseControl>(StaticUtils.computeMapCapacity(responseControls.length));
        for (Control c : responseControls) {
            if (!c.getOID().equals(UNIQUENESS_RESPONSE_OID)) continue;
            UniquenessResponseControl urc = c instanceof UniquenessResponseControl ? (UniquenessResponseControl)c : new UniquenessResponseControl().decodeControl(c.getOID(), c.isCritical(), c.getValue());
            String uniquenessID = urc.getUniquenessID();
            if (controlMap.containsKey(uniquenessID)) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_GET_ID_CONFLICT.get(uniquenessID));
            }
            controlMap.put(uniquenessID, urc);
        }
        return Collections.unmodifiableMap(controlMap);
    }

    public String getUniquenessID() {
        return this.uniquenessID;
    }

    public Boolean getPreCommitValidationPassed() {
        return this.preCommitValidationPassed;
    }

    public Boolean getPostCommitValidationPassed() {
        return this.postCommitValidationPassed;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    @Override
    public String getControlName() {
        return ControlMessages.INFO_UNIQUENESS_RES_CONTROL_NAME.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("UniquenessResponseControl(uniquenessID='");
        buffer.append(this.uniquenessID);
        buffer.append('\'');
        if (this.preCommitValidationPassed == null) {
            buffer.append(", preCommitValidationAttempted=false");
        } else {
            buffer.append(", preCommitValidationPassed=");
            buffer.append(this.preCommitValidationPassed);
        }
        if (this.postCommitValidationPassed == null) {
            buffer.append(", postCommitValidationAttempted=false");
        } else {
            buffer.append(", postCommitValidationPassed=");
            buffer.append(this.postCommitValidationPassed);
        }
        if (this.validationMessage != null) {
            buffer.append(", validationMessage='");
            buffer.append(this.validationMessage);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

