/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.io.Serializable;
import java.net.InetAddress;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IPAddressArgumentValueValidator
extends ArgumentValueValidator
implements Serializable {
    private static final long serialVersionUID = -3923873375428600467L;
    private final boolean acceptIPv4Addresses;
    private final boolean acceptIPv6Addresses;

    public IPAddressArgumentValueValidator() {
        this(true, true);
    }

    public IPAddressArgumentValueValidator(boolean acceptIPv4Addresses, boolean acceptIPv6Addresses) {
        Validator.ensureTrue(acceptIPv4Addresses || acceptIPv6Addresses, "One or both of the acceptIPv4Addresses and acceptIPv6Addresses arguments must have a value of 'true'.");
        this.acceptIPv4Addresses = acceptIPv4Addresses;
        this.acceptIPv6Addresses = acceptIPv6Addresses;
    }

    public boolean acceptIPv4Addresses() {
        return this.acceptIPv4Addresses;
    }

    public boolean acceptIPv6Addresses() {
        return this.acceptIPv6Addresses;
    }

    @Override
    public void validateArgumentValue(Argument argument, String valueString) throws ArgumentException {
        boolean isIPv6;
        boolean bl = isIPv6 = valueString.indexOf(58) >= 0;
        if (isIPv6) {
            for (char c : valueString.toCharArray()) {
                if (c == ':' || c == '.' || c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                throw new ArgumentException(ArgsMessages.ERR_IP_VALIDATOR_ILLEGAL_IPV6_CHAR.get(valueString, argument.getIdentifierString(), Character.valueOf(c)));
            }
        } else if (valueString.indexOf(46) >= 0) {
            for (char c : valueString.toCharArray()) {
                if (c == '.' || c >= '0' && c <= '9') continue;
                throw new ArgumentException(ArgsMessages.ERR_IP_VALIDATOR_ILLEGAL_IPV4_CHAR.get(valueString, argument.getIdentifierString(), Character.valueOf(c)));
            }
        } else {
            throw new ArgumentException(ArgsMessages.ERR_IP_VALIDATOR_MALFORMED.get(valueString, argument.getIdentifierString()));
        }
        try {
            InetAddress.getByName(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_IP_VALIDATOR_MALFORMED.get(valueString, argument.getIdentifierString()), e);
        }
        if (isIPv6) {
            if (!this.acceptIPv6Addresses) {
                throw new ArgumentException(ArgsMessages.ERR_IP_VALIDATOR_IPV6_NOT_ACCEPTED.get(valueString, argument.getIdentifierString()));
            }
        } else if (!this.acceptIPv4Addresses) {
            throw new ArgumentException(ArgsMessages.ERR_IP_VALIDATOR_IPV4_NOT_ACCEPTED.get(valueString, argument.getIdentifierString()));
        }
    }

    public static boolean isValidNumericIPAddress(String s) {
        return IPAddressArgumentValueValidator.isValidNumericIPv4Address(s) || IPAddressArgumentValueValidator.isValidNumericIPv6Address(s);
    }

    public static boolean isValidNumericIPv4Address(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (c == '.' || c >= '0' && c <= '9') continue;
            return false;
        }
        try {
            InetAddress.getByName(s);
            return true;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    public static boolean isValidNumericIPv6Address(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        boolean colonFound = false;
        for (char c : s.toCharArray()) {
            if (c == ':') {
                colonFound = true;
                continue;
            }
            if (c == '.' || c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        if (colonFound) {
            try {
                InetAddress.getByName(s);
                return true;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("IPAddressArgumentValueValidator(acceptIPv4Addresses=");
        buffer.append(this.acceptIPv4Addresses);
        buffer.append(", acceptIPv6Addresses=");
        buffer.append(this.acceptIPv6Addresses);
        buffer.append(')');
    }
}

