/*
 * Copyright 2022 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright 2020-2022 Ping Identity Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2022 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;



import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;



/**
 * This enum defines a set of message keys for messages in the
 * com.unboundid.ldap.sdk.unboundidds.logs.v2.text package, which correspond to messages in the
 * unboundid-ldapsdk-text-log.properties properties file.
 * <BR><BR>
 * This source file was generated from the properties file.
 * Do not edit it directly.
 */
enum TextLogMessages
{
  /**
   * Unable to parse string ''{0}'' as a text-formatted access log message because the message type could not be determined.
   */
  ERR_TEXT_ACCESS_READER_CANNOT_DETERMINE_MESSAGE_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because the message type could not be determined."),



  /**
   * Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for an assurance completed log message.
   */
  ERR_TEXT_ACCESS_READER_UNSUPPORTED_ASSURANCE_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for an assurance completed log message."),



  /**
   * Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a forward failed log message.
   */
  ERR_TEXT_ACCESS_READER_UNSUPPORTED_FORWARD_FAILED_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a forward failed log message."),



  /**
   * Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a forward log message.
   */
  ERR_TEXT_ACCESS_READER_UNSUPPORTED_FORWARD_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a forward log message."),



  /**
   * Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a request log message.
   */
  ERR_TEXT_ACCESS_READER_UNSUPPORTED_REQUEST_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a request log message."),



  /**
   * Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a result log message.
   */
  ERR_TEXT_ACCESS_READER_UNSUPPORTED_RESULT_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a result log message."),



  /**
   * Unable to parse value ''{0}'' in log message ''{1}'' because it has an invalid hex-escaped character.
   */
  ERR_TEXT_LOG_MESSAGE_INVALID_ESCAPED_CHARACTER("Unable to parse value ''{0}'' in log message ''{1}'' because it has an invalid hex-escaped character."),



  /**
   * Unable to parse string ''{0}'' as a text-formatted log message because it does not start with a valid timestamp.
   */
  ERR_TEXT_LOG_MESSAGE_MISSING_TIMESTAMP("Unable to parse string ''{0}'' as a text-formatted log message because it does not start with a valid timestamp."),



  /**
   * Unable to parse the value of field ''{0}'' as a Boolean in text-formatted log message {1}.
   */
  ERR_TEXT_LOG_MESSAGE_VALUE_NOT_BOOLEAN("Unable to parse the value of field ''{0}'' as a Boolean in text-formatted log message {1}."),



  /**
   * Unable to parse the value of field ''{0}'' as a floating-point number in text-formatted log message {1}.
   */
  ERR_TEXT_LOG_MESSAGE_VALUE_NOT_FLOATING_POINT("Unable to parse the value of field ''{0}'' as a floating-point number in text-formatted log message {1}."),



  /**
   * Unable to parse the value of field ''{0}'' as a generalized time value in text-formatted log message {1}.
   */
  ERR_TEXT_LOG_MESSAGE_VALUE_NOT_GENERALIZED_TIME("Unable to parse the value of field ''{0}'' as a generalized time value in text-formatted log message {1}."),



  /**
   * Unable to parse the value of field ''{0}'' as an integer in text-formatted log message ''{1}''.
   */
  ERR_TEXT_LOG_MESSAGE_VALUE_NOT_INTEGER("Unable to parse the value of field ''{0}'' as an integer in text-formatted log message ''{1}''."),



  /**
   * Unable to parse the value of field ''{0}'' as an RFC 3339 timestamp in text-formatted log message {1}.
   */
  ERR_TEXT_LOG_MESSAGE_VALUE_NOT_RFC_3339_TIMESTAMP("Unable to parse the value of field ''{0}'' as an RFC 3339 timestamp in text-formatted log message {1}.");



  /**
   * Indicates whether the unit tests are currently running.
   */
  private static final boolean IS_WITHIN_UNIT_TESTS =
       Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") ||
       Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");



  /**
   * A pre-allocated array of zero objects to use for messages
   * that do not require any arguments.
   */
  private static final Object[] NO_ARGS = new Object[0];



  /**
   * The resource bundle that will be used to load the properties file.
   */
  private static final ResourceBundle RESOURCE_BUNDLE;
  static
  {
    ResourceBundle rb = null;
    try
    {
      rb = ResourceBundle.getBundle("unboundid-ldapsdk-text-log");
    } catch (final Exception e) {}
    RESOURCE_BUNDLE = rb;
  }



  /**
   * The map that will be used to hold the unformatted message strings, indexed by property name.
   */
  private static final ConcurrentHashMap<TextLogMessages,String> MESSAGE_STRINGS = new ConcurrentHashMap<>(100);



  /**
   * The map that will be used to hold the message format objects, indexed by property name.
   */
  private static final ConcurrentHashMap<TextLogMessages,MessageFormat> MESSAGES = new ConcurrentHashMap<>(100);



  // The default text for this message
  private final String defaultText;



  /**
   * Creates a new message key.
   */
  private TextLogMessages(final String defaultText)
  {
    this.defaultText = defaultText;
  }



  /**
   * Retrieves a localized version of the message.
   * This method should only be used for messages that do not take any
   * arguments.
   *
   * @return  A localized version of the message.
   */
  public String get()
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }

    final String formattedMessage;
    synchronized (f)
    {
      formattedMessage = f.format(NO_ARGS);
    }

    if (IS_WITHIN_UNIT_TESTS)
    {
      if (formattedMessage.contains("{0}") ||
          formattedMessage.contains("{0,number,0}") ||
          formattedMessage.contains("{1}") ||
          formattedMessage.contains("{1,number,0}") ||
          formattedMessage.contains("{2}") ||
          formattedMessage.contains("{2,number,0}") ||
          formattedMessage.contains("{3}") ||
          formattedMessage.contains("{3,number,0}") ||
          formattedMessage.contains("{4}") ||
          formattedMessage.contains("{4,number,0}") ||
          formattedMessage.contains("{5}") ||
          formattedMessage.contains("{5,number,0}") ||
          formattedMessage.contains("{6}") ||
          formattedMessage.contains("{6,number,0}") ||
          formattedMessage.contains("{7}") ||
          formattedMessage.contains("{7,number,0}") ||
          formattedMessage.contains("{8}") ||
          formattedMessage.contains("{8,number,0}") ||
          formattedMessage.contains("{9}") ||
          formattedMessage.contains("{9,number,0}") ||
          formattedMessage.contains("{10}") ||
          formattedMessage.contains("{10,number,0}"))
      {
        throw new IllegalArgumentException(
             "Message " + getClass().getName() + '.' + name() +
                  " contains an un-replaced token:  " + formattedMessage);
      }
    }

    return formattedMessage;
  }



  /**
   * Retrieves a localized version of the message.
   *
   * @param  args  The arguments to use to format the message.
   *
   * @return  A localized version of the message.
   */
  public String get(final Object... args)
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }

    final String formattedMessage;
    synchronized (f)
    {
      formattedMessage = f.format(args);
    }

    if (IS_WITHIN_UNIT_TESTS)
    {
      if (formattedMessage.contains("{0}") ||
          formattedMessage.contains("{0,number,0}") ||
          formattedMessage.contains("{1}") ||
          formattedMessage.contains("{1,number,0}") ||
          formattedMessage.contains("{2}") ||
          formattedMessage.contains("{2,number,0}") ||
          formattedMessage.contains("{3}") ||
          formattedMessage.contains("{3,number,0}") ||
          formattedMessage.contains("{4}") ||
          formattedMessage.contains("{4,number,0}") ||
          formattedMessage.contains("{5}") ||
          formattedMessage.contains("{5,number,0}") ||
          formattedMessage.contains("{6}") ||
          formattedMessage.contains("{6,number,0}") ||
          formattedMessage.contains("{7}") ||
          formattedMessage.contains("{7,number,0}") ||
          formattedMessage.contains("{8}") ||
          formattedMessage.contains("{8,number,0}") ||
          formattedMessage.contains("{9}") ||
          formattedMessage.contains("{9,number,0}") ||
          formattedMessage.contains("{10}") ||
          formattedMessage.contains("{10,number,0}"))
      {
        throw new IllegalArgumentException(
             "Message " + getClass().getName() + '.' + name() +
                  " contains an un-replaced token:  " + formattedMessage);
      }
    }

    return formattedMessage;
  }



  /**
   * Retrieves a string representation of this message key.
   *
   * @return  A string representation of this message key.
   */
  @Override()
  public String toString()
  {
    String s = MESSAGE_STRINGS.get(this);
    if (s == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        s = defaultText;
      }
      else
      {
        try
        {
          s = RESOURCE_BUNDLE.getString(name());
        }
        catch (final Exception e)
        {
          s = defaultText;
        }
        MESSAGE_STRINGS.putIfAbsent(this, s);
      }
    }

    return s;
  }
}

