/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class EventUtil {
    private EventUtil() {
    }

    static <T> void fireEvents(List<T> listeners, Consumer<T> action, boolean removeFailingListeners) {
        assert (action != null);
        if (listeners == null) {
            return;
        }
        RuntimeException firstException = null;
        for (T listener : new ArrayList<T>(listeners)) {
            try {
                action.accept(listener);
            }
            catch (RuntimeException e) {
                if (removeFailingListeners) {
                    listeners.remove(listener);
                }
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                firstException.addSuppressed(e);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }
}

