/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor.utils;

import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandlerCommand;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class ThemeEditorHistory {
    private static final Map<Integer, UiHistory> history = new HashMap<Integer, UiHistory>();
    private Integer uiId;

    private ThemeEditorHistory() {
    }

    private ThemeEditorHistory(Integer uiId) {
        this.uiId = uiId;
    }

    public static ThemeEditorHistory forUi(Integer uiId) {
        return new ThemeEditorHistory(uiId);
    }

    public void clean() {
        history.remove(this.uiId);
    }

    public void put(String requestId, MessageHandler.ExecuteAndUndo executeAndUndo) {
        this.getUiHistory().put(requestId, executeAndUndo);
    }

    public boolean containsKey(String requestId) {
        if (requestId == null) {
            return false;
        }
        return this.getUiHistory().containsKey(requestId);
    }

    public MessageHandlerCommand getExecuteCommand(String requestId) {
        if (!this.containsKey(requestId)) {
            return null;
        }
        return ((MessageHandler.ExecuteAndUndo)this.getUiHistory().get(requestId)).executeCommand();
    }

    public Optional<MessageHandlerCommand> getUndoCommand(String requestId) {
        if (!this.containsKey(requestId)) {
            return null;
        }
        return ((MessageHandler.ExecuteAndUndo)this.getUiHistory().get(requestId)).undoCommand();
    }

    private UiHistory getUiHistory() {
        if (!history.containsKey(this.uiId)) {
            history.put(this.uiId, new UiHistory());
        }
        return history.get(this.uiId);
    }

    private static class UiHistory
    extends LinkedHashMap<String, MessageHandler.ExecuteAndUndo> {
        private static final int LIMIT = 100;

        private UiHistory() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, MessageHandler.ExecuteAndUndo> eldest) {
            return this.size() > 100;
        }
    }
}

