/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import java.util.Optional;

@Tag(value="img")
public class Image
extends HtmlContainer
implements ClickNotifier<Image>,
HasAriaLabel {
    private static final String ALT_ATTRIBUTE = "alt";
    private static final PropertyDescriptor<String, String> srcDescriptor = PropertyDescriptors.attributeWithDefault((String)"src", (String)"");

    public Image() {
    }

    public Image(String src, String alt) {
        this.setSrc(src);
        this.setAlt(alt);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public Image(AbstractStreamResource src, String alt) {
        this.setSrc(src);
        this.setAlt(alt);
    }

    public Image(DownloadHandler downloadHandler, String alt) {
        this.setSrc(downloadHandler);
        this.setAlt(alt);
    }

    public String getSrc() {
        return (String)this.get(srcDescriptor);
    }

    public void setSrc(String src) {
        this.set(srcDescriptor, src);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public void setSrc(AbstractStreamResource src) {
        this.getElement().setAttribute("src", src);
    }

    public void setSrc(DownloadHandler downloadHandler) {
        if (downloadHandler instanceof AbstractDownloadHandler) {
            AbstractDownloadHandler handler = (AbstractDownloadHandler)downloadHandler;
            handler.inline();
        }
        this.getElement().setAttribute("src", (ElementRequestHandler)downloadHandler);
    }

    public void setAlt(String alt) {
        if (alt == null) {
            this.getElement().removeAttribute(ALT_ATTRIBUTE);
        } else {
            this.getElement().setAttribute(ALT_ATTRIBUTE, alt);
        }
    }

    public Optional<String> getAlt() {
        return Optional.ofNullable(this.getElement().getAttribute(ALT_ATTRIBUTE));
    }
}

