/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.server.communication.PushHandler;
import java.io.IOException;
import java.io.Serializable;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushAtmosphereHandler
extends AbstractReflectorAtmosphereHandler
implements Serializable {
    private PushHandler pushHandler = null;

    public void setPushHandler(PushHandler pushHandler) {
        this.pushHandler = pushHandler;
    }

    private static final Logger getLogger() {
        return LoggerFactory.getLogger((String)PushAtmosphereHandler.class.getName());
    }

    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        super.onStateChange(event);
        if (this.pushHandler == null) {
            PushAtmosphereHandler.getLogger().warn("AtmosphereHandler.onStateChange called before PushHandler has been set. This should really not happen");
            return;
        }
        if (event.isCancelled() || event.isResumedOnTimeout()) {
            this.pushHandler.connectionLost(event);
        }
    }

    public void onRequest(AtmosphereResource resource) {
        if (this.pushHandler == null) {
            PushAtmosphereHandler.getLogger().warn("AtmosphereHandler.onRequest called before PushHandler has been set. This should really not happen");
            return;
        }
        AtmosphereRequest req = resource.getRequest();
        if (req.getMethod().equalsIgnoreCase("GET")) {
            this.onConnect(resource);
        } else if (req.getMethod().equalsIgnoreCase("POST")) {
            this.onMessage(resource);
        }
    }

    private void onMessage(AtmosphereResource resource) {
        this.pushHandler.onMessage(resource);
    }

    private void onConnect(AtmosphereResource resource) {
        resource.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceListener());
        this.pushHandler.onConnect(resource);
    }

    private class AtmosphereResourceListener
    extends AtmosphereResourceEventListenerAdapter
    implements Serializable {
        private AtmosphereResourceListener() {
        }

        public void onDisconnect(AtmosphereResourceEvent event) {
            super.onDisconnect(event);
            PushAtmosphereHandler.this.pushHandler.connectionLost(event);
        }

        public void onThrowable(AtmosphereResourceEvent event) {
            Throwable throwable = event.throwable();
            if (throwable instanceof IOException && throwable.getMessage() != null && throwable.getMessage().contains("Connection remotely closed")) {
                PushAtmosphereHandler.getLogger().debug("Push connection remotely closed", throwable);
            } else {
                PushAtmosphereHandler.getLogger().error("Exception in push connection", throwable);
            }
            PushAtmosphereHandler.this.pushHandler.connectionLost(event);
        }
    }
}

