/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone;

import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.models.MethodInfoModel;
import com.vaadin.hilla.parser.models.MethodParameterInfoModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.nodes.MethodNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.MethodParameterNode;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

public final class MethodParameterPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    public void enter(NodePath<?> nodePath) {
        PathItem pathItem;
        Node node = nodePath.getNode();
        Node parentNode = nodePath.getParentPath().getNode();
        if (node instanceof MethodParameterNode && parentNode instanceof MethodNode && (pathItem = (PathItem)parentNode.getTarget()).getPost().getRequestBody() == null) {
            pathItem.getPost().setRequestBody(this.createRequestBody());
        }
    }

    public void exit(NodePath<?> nodePath) {
    }

    public @NonNull NodeDependencies scan(@NonNull NodeDependencies nodeDependencies) {
        if (nodeDependencies.getNode() instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)nodeDependencies.getNode();
            return nodeDependencies.appendChildNodes(this.getParametersStream(methodNode));
        }
        return nodeDependencies;
    }

    private RequestBody createRequestBody() {
        ObjectSchema requestMap = new ObjectSchema();
        return new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema((Schema)requestMap)));
    }

    private Stream<Node<?, ?>> getParametersStream(MethodNode methodNode) {
        ArrayList parameters = new ArrayList(((MethodInfoModel)methodNode.getSource()).getParameters());
        ArrayList<MethodParameterNode> parameterNodes = new ArrayList<MethodParameterNode>(parameters.size());
        for (int i = 0; i < parameters.size(); ++i) {
            MethodParameterInfoModel parameter = (MethodParameterInfoModel)parameters.get(i);
            String name = Optional.ofNullable(((MethodParameterInfoModel)parameters.get(i)).getName()).orElse(String.format("_param_%d", i));
            parameterNodes.add(i, MethodParameterNode.of(parameter, name));
        }
        return parameterNodes.stream();
    }
}

