/*
 * Copyright 2000-2016 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.event.dd;

import java.io.Serializable;

import com.vaadin.event.Transferable;
import com.vaadin.event.dd.acceptcriteria.AcceptCriterion;

/**
 * DragAndDropEvent wraps information related to drag and drop operation. It is
 * passed by terminal implementation for
 * {@link DropHandler#drop(DragAndDropEvent)} and
 * {@link AcceptCriterion#accept(DragAndDropEvent)} methods.
 * <p>
 * DragAndDropEvent instances contains both the dragged data in
 * {@link Transferable} (generated by {@link DragSource} and details about the
 * current drop event in {@link TargetDetails} (generated by {@link DropTarget}.
 *
 * @since 6.3
 *
 */
public class DragAndDropEvent implements Serializable {
    private final Transferable transferable;
    private final TargetDetails dropTargetDetails;

    public DragAndDropEvent(Transferable transferable,
            TargetDetails dropTargetDetails) {
        this.transferable = transferable;
        this.dropTargetDetails = dropTargetDetails;
    }

    /**
     * @return the Transferable instance representing the data dragged in this
     *         drag and drop event
     */
    public Transferable getTransferable() {
        return transferable;
    }

    /**
     * @return the TargetDetails containing drop target related details of drag
     *         and drop operation
     */
    public TargetDetails getTargetDetails() {
        return dropTargetDetails;
    }

}
