/*
 * Copyright 2000-2017 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.icons;

import com.vaadin.server.FontIcon;

/**
 * {@link FontIcon} that represents the <a
 * href="https://vaadin.com/vaadin-icons">Vaadin Icons font</a>.
 * 
 * @author Teemu Pöntelin, Vaadin Ltd (add-on)
 * @author Jarmo Kemppainen, Vaadin Ltd (font)
 *
 */
public enum VaadinIcons implements FontIcon {

    ABACUS(0xE682),
    ABSOLUTE_POSITION(0xE61E),
    ACADEMY_CAP(0XE902),
    ACCESSIBILITY(0xE683),
    ACCORDION_MENU(0xE61F),
    ADD_DOCK(0xE620),
    ADJUST(0xE74A),
    ADOBE_FLASH(0xE648),
    AIRPLANE(0xE684),
    ALARM(0XE903),
    ALIGN_CENTER(0xE74B),
    ALIGN_JUSTIFY(0xE7AE),
    ALIGN_LEFT(0xE74C),
    ALIGN_RIGHT(0xE74D),
    ALT(0XE905),
    ALT_A(0XE904),
    AMBULANCE(0XE906),
    ANCHOR(0xE685),
    ANGLE_DOUBLE_DOWN(0xE6E6),
    ANGLE_DOUBLE_LEFT(0xE6E7),
    ANGLE_DOUBLE_RIGHT(0xE6E8),
    ANGLE_DOUBLE_UP(0xE6E9),
    ANGLE_DOWN(0xE6EA),
    ANGLE_LEFT(0xE6EB),
    ANGLE_RIGHT(0xE6EC),
    ANGLE_UP(0xE6ED),
    ARCHIVE(0xE6EE),
    ARCHIVES(0xE621),
    AREA_SELECT(0xE806),
    ARROW_BACKWARD(0xE622),
    ARROW_CIRCLE_DOWN(0xE6F0),
    ARROW_CIRCLE_DOWN_O(0xE6EF),
    ARROW_CIRCLE_LEFT(0xE6F2),
    ARROW_CIRCLE_LEFT_O(0xE6F1),
    ARROW_CIRCLE_RIGHT(0xE6F4),
    ARROW_CIRCLE_RIGHT_O(0xE6F3),
    ARROW_CIRCLE_UP(0xE6F6),
    ARROW_CIRCLE_UP_O(0xE6F5),
    ARROW_DOWN(0xE7AF),
    ARROW_FORWARD(0xE623),
    ARROW_LEFT(0xE7B0),
    ARROW_LONG_DOWN(0xE74E),
    ARROW_LONG_LEFT(0xE74F),
    ARROW_RIGHT(0xE7B1),
    ARROW_UP(0xE7B2),
    ARROWS(0xE755),
    ARROWS_CROSS(0xE750),
    ARROWS_LONG_H(0xE751),
    ARROWS_LONG_RIGHT(0xE752),
    ARROWS_LONG_UP(0xE753),
    ARROWS_LONG_V(0xE754),
    ASTERISK(0xE686),
    AT(0xE624),
    AUTOMATION(0xE687),
    BACKSPACE(0XE908),
    BACKSPACE_A(0XE907),
    BACKWARDS(0xE756),
    BAN(0xE6F7),
    BAR_CHART(0xE757),
    BAR_CHART_H(0XE909),
    BAR_CHART_V(0XE90A),
    BARCODE(0xE688),
    BED(0XE90B),
    BELL(0xE7B4),
    BELL_O(0xE758),
    BELL_SLASH(0xE626),
    BELL_SLASH_O(0xE625),
    BOAT(0xE627),
    BOLD(0xE6F8),
    BOLT(0xE759),
    BOMB(0xE689),
    BOOK(0xE6F9),
    BOOK_DOLLAR(0xE600),
    BOOK_PERCENT(0xE601),
    BOOKMARK(0xE7B6),
    BOOKMARK_O(0xE7B5),
    BRIEFCASE(0xE602),
    BROWSER(0xE628),
    BUG(0xE68B),
    BUG_O(0xE68A),
    BUILDING(0xE7B8),
    BUILDING_O(0xE7B7),
    BULLETS(0xE629),
    BULLSEYE(0xE6FA),
    BUSS(0XE90C),
    BUTTON(0xE62A),
    CALC(0xE68C),
    CALC_BOOK(0xE62B),
    CALENDAR(0xE7BA),
    CALENDAR_BRIEFCASE(0xE604),
    CALENDAR_CLOCK(0xE605),
    CALENDAR_ENVELOPE(0xE62C),
    CALENDAR_O(0xE7B9),
    CALENDAR_USER(0xE606),
    CAMERA(0xE7BB),
    CAR(0xE62D),
    CARET_DOWN(0xE7BC),
    CARET_LEFT(0xE7BD),
    CARET_RIGHT(0xE7BE),
    CARET_SQUARE_DOWN_O(0xE7BF),
    CARET_SQUARE_LEFT_O(0xE7C0),
    CARET_SQUARE_RIGHT_O(0xE7C1),
    CARET_SQUARE_UP_O(0xE7C2),
    CARET_UP(0xE7C3),
    CART(0xE6FC),
    CART_O(0xE6FB),
    CASH(0XE901),
    CHART(0xE68E),
    CHART_3D(0XE90D),
    CHART_GRID(0XE90E),
    CHART_LINE(0xE68D),
    CHART_TIMELINE(0XE90F),
    CHAT(0xE75A),
    CHECK(0xE75B),
    CHECK_CIRCLE(0xE7C5),
    CHECK_CIRCLE_O(0xE7C4),
    CHECK_SQUARE(0xE62E),
    CHECK_SQUARE_O(0xE6FD),
    CHEVRON_CIRCLE_DOWN(0xE7C7),
    CHEVRON_CIRCLE_DOWN_O(0xE7C6),
    CHEVRON_CIRCLE_LEFT(0xE7C9),
    CHEVRON_CIRCLE_LEFT_O(0xE7C8),
    CHEVRON_CIRCLE_RIGHT(0xE7CB),
    CHEVRON_CIRCLE_RIGHT_O(0xE7CA),
    CHEVRON_CIRCLE_UP(0xE7CD),
    CHEVRON_CIRCLE_UP_O(0xE7CC),
    CHEVRON_DOWN(0xE7CE),
    CHEVRON_DOWN_SMALL(0XE965),
    CHEVRON_LEFT(0xE7CF),
    CHEVRON_LEFT_SMALL(0XE966),
    CHEVRON_RIGHT(0xE7D0),
    CHEVRON_RIGHT_SMALL(0XE967),
    CHEVRON_UP(0xE7D1),
    CHEVRON_UP_SMALL(0XE968),
    CHILD(0xE62F),
    CIRCLE(0xE75D),
    CIRCLE_THIN(0xE75C),
    CLIPBOARD(0xE635),
    CLIPBOARD_CHECK(0XE910),
    CLIPBOARD_CROSS(0xE630),
    CLIPBOARD_HEART(0xE631),
    CLIPBOARD_PULSE(0xE632),
    CLIPBOARD_TEXT(0xE633),
    CLIPBOARD_USER(0xE634),
    CLOCK(0xE7D2),
    CLOSE(0xE7AD),
    CLOSE_BIG(0XE916),
    CLOSE_CIRCLE(0xE811),
    CLOSE_CIRCLE_O(0xE810),
    CLOSE_SMALL(0XE911),
    CLOUD(0xE763),
    CLOUD_DOWNLOAD(0xE75F),
    CLOUD_DOWNLOAD_O(0xE75E),
    CLOUD_O(0xE760),
    CLOUD_UPLOAD(0xE762),
    CLOUD_UPLOAD_O(0xE761),
    CLUSTER(0XE912),
    CODE(0xE68F),
    COFFEE(0xE690),
    COG(0xE7D3),
    COG_O(0xE764),
    COGS(0xE691),
    COINS(0XE914),
    COIN_PILES(0XE913),
    COMBOBOX(0xE636),
    COMMENT(0xE768),
    COMMENT_ELLIPSIS(0xE766),
    COMMENT_ELLIPSIS_O(0xE765),
    COMMENT_O(0xE767),
    COMMENTS(0xE76A),
    COMMENTS_O(0xE769),
    COMPILE(0XE915),
    COMPRESS(0xE76B),
    COMPRESS_SQUARE(0xE637),
    CONNECT(0xE76D),
    CONNECT_O(0xE76C),
    CONTROLLER(0xE692),
    COPY(0xE7D5),
    COPY_O(0xE7D4),
    COPYRIGHT(0xE638),
    CORNER_LOWER_LEFT(0xE693),
    CORNER_LOWER_RIGHT(0xE694),
    CORNER_UPPER_LEFT(0xE695),
    CORNER_UPPER_RIGHT(0xE696),
    CREDIT_CARD(0xE76E),
    CROP(0xE76F),
    CROSS_CUTLERY(0xE6FE),
    CROSSHAIRS(0xE7D6),
    CSS(0xE639),
    CTRL(0XE918),
    CTRL_A(0XE917),
    CUBE(0xE697),
    CUBES(0xE698),
    CURLY_BRACKETS(0xE63A),
    CURSOR(0XE91A),
    CURSOR_O(0XE919),
    CUTLERY(0xE6FF),
    DASHBOARD(0xE700),
    DATABASE(0xE737),
    DATE_INPUT(0xE63B),
    DEINDENT(0xE770),
    DEL(0XE91C),
    DEL_A(0XE91B),
    DENTAL_CHAIR(0xE607),
    DESKTOP(0xE7D7),
    DIAMOND(0XE91E),
    DIAMOND_O(0XE91D),
    DIPLOMA(0XE964),
    DIPLOMA_SCROLL(0XE969),
    DISC(0xE701),
    DOCTOR(0xE609),
    DOCTOR_BRIEFCASE(0xE608),
    DOLLAR(0xE60A),
    DOT_CIRCLE(0xE702),
    DOWNLOAD(0xE703),
    DOWNLOAD_ALT(0xE699),
    DROP(0xE704),
    EDIT(0xE771),
    EJECT(0xE772),
    ELASTIC(0xE63C),
    ELLIPSIS_CIRCLE(0xE7DA),
    ELLIPSIS_CIRCLE_O(0xE7D9),
    ELLIPSIS_DOTS_H(0XE91F),
    ELLIPSIS_DOTS_V(0XE920),
    ELLIPSIS_H(0xE773),
    ELLIPSIS_V(0xE774),
    ENTER(0XE922),
    ENTER_ARROW(0XE921),
    ENVELOPE(0xE7DC),
    ENVELOPES(0XE924),
    ENVELOPES_O(0XE923),
    ENVELOPE_O(0xE7DB),
    ENVELOPE_OPEN(0xE63E),
    ENVELOPE_OPEN_O(0xE63D),
    ERASER(0xE69A),
    ESC(0XE926),
    ESC_A(0XE925),
    EURO(0XE927),
    EXCHANGE(0xE705),
    EXCLAMATION(0xE708),
    EXCLAMATION_CIRCLE(0xE707),
    EXCLAMATION_CIRCLE_O(0xE706),
    EXIT(0xE60C),
    EXIT_O(0xE60B),
    EXPAND(0xE776),
    EXPAND_FULL(0xE775),
    EXPAND_SQUARE(0xE7DD),
    EXTERNAL_BROWSER(0xE63F),
    EXTERNAL_LINK(0xE7DE),
    EYE(0xE7DF),
    EYE_SLASH(0xE709),
    EYEDROPPER(0xE640),
    FACEBOOK(0xE69C),
    FACEBOOK_SQUARE(0xE69B),
    FACTORY(0xE641),
    FAMILY(0XE928),
    FAST_BACKWARD(0xE777),
    FAST_FORWARD(0xE778),
    FEMALE(0xE69D),
    FILE(0xE7E3),
    FILE_ADD(0XE929),
    FILE_CODE(0xE70A),
    FILE_FONT(0xE69E),
    FILE_MOVIE(0xE70B),
    FILE_O(0xE7E0),
    FILE_PICTURE(0xE70C),
    FILE_PRESENTATION(0xE69F),
    FILE_PROCESS(0xE642),
    FILE_REFRESH(0xE643),
    FILE_REMOVE(0XE92A),
    FILE_SEARCH(0XE92B),
    FILE_SOUND(0xE70D),
    FILE_START(0xE644),
    FILE_TABLE(0xE6A0),
    FILE_TEXT(0xE7E2),
    FILE_TEXT_O(0xE7E1),
    FILE_TREE(0xE647),
    FILE_TREE_SMALL(0xE645),
    FILE_TREE_SUB(0xE646),
    FILE_ZIP(0xE70E),
    FILL(0xE6A1),
    FILM(0xE779),
    FILTER(0xE6A2),
    FIRE(0xE6A3),
    FLAG(0xE711),
    FLAG_CHECKERED(0xE70F),
    FLAG_O(0xE710),
    FLASH(0xE712),
    FLASK(0xE7E4),
    FLIGHT_LANDING(0XE92C),
    FLIGHT_TAKEOFF(0XE92D),
    FLIP_H(0xE649),
    FLIP_V(0xE64A),
    FOLDER(0xE7E6),
    FOLDER_ADD(0XE92E),
    FOLDER_O(0xE7E5),
    FOLDER_OPEN(0xE77B),
    FOLDER_OPEN_O(0xE77A),
    FOLDER_REMOVE(0XE92F),
    FOLDER_SEARCH(0XE930),
    FONT(0xE713),
    FORM(0xE64B),
    FORWARD(0xE77C),
    FROWN_O(0xE6A4),
    FUNCION(0xE64C),
    FUNNEL(0XE931),
    GAMEPAD(0xE714),
    GAVEL(0xE6A5),
    GIFT(0xE715),
    GLASS(0xE77D),
    GLASSES(0xE7E7),
    GLOBE(0xE77E),
    GLOBE_WIRE(0XE932),
    GOLF(0xE60D),
    GOOGLE_PLUS(0xE6A7),
    GOOGLE_PLUS_SQUARE(0xE6A6),
    GRAB(0xE64D),
    GRID(0xE651),
    GRID_BEVEL(0xE64E),
    GRID_BIG(0xE7E9),
    GRID_BIG_O(0xE7E8),
    GRID_H(0xE64F),
    GRID_SMALL(0xE7EB),
    GRID_SMALL_O(0xE7EA),
    GRID_V(0xE650),
    GROUP(0xE60E),
    HAMMER(0XE933),
    HAND(0xE652),
    HANDLE_CORNER(0xE716),
    HANDSHAKE(0XE934),
    HANDS_UP(0xE6A8),
    HARDDRIVE(0xE718),
    HARDDRIVE_O(0xE717),
    HASH(0xE6A9),
    HEADER(0xE719),
    HEADPHONES(0xE71A),
    HEADSET(0XE935),
    HEALTH_CARD(0xE60F),
    HEART(0xE780),
    HEART_O(0xE77F),
    HOME(0xE7ED),
    HOME_O(0xE7EC),
    HOSPITAL(0XE936),
    HOURGLASS(0XE93A),
    HOURGLASS_EMPTY(0XE937),
    HOURGLASS_END(0XE938),
    HOURGLASS_START(0XE939),
    INBOX(0xE71B),
    INDENT(0xE781),
    INFO(0xE71E),
    INFO_CIRCLE(0xE71D),
    INFO_CIRCLE_O(0xE71C),
    INPUT(0xE653),
    INSERT(0xE7D8),
    INSTITUTION(0xE6AA),
    INVOICE(0xE610),
    ITALIC(0xE720),
    KEY(0xE6AC),
    KEY_O(0xE6AB),
    KEYBOARD(0xE722),
    KEYBOARD_O(0xE721),
    LAPTOP(0xE782),
    LAYOUT(0xE654),
    LEVEL_DOWN(0xE783),
    LEVEL_DOWN_BOLD(0xE611),
    LEVEL_LEFT(0xE784),
    LEVEL_LEFT_BOLD(0xE612),
    LEVEL_RIGHT(0xE785),
    LEVEL_RIGHT_BOLD(0xE655),
    LEVEL_UP(0xE786),
    LEVEL_UP_BOLD(0xE613),
    LIFEBUOY(0xE6AD),
    LIGHTBULB(0xE6AE),
    LINE_BAR_CHART(0XE93B),
    LINE_CHART(0XE93C),
    LINE_H(0xE723),
    LINE_V(0xE724),
    LINES(0xE7EF),
    LINES_LIST(0xE7EE),
    LINK(0xE725),
    LIST(0xE7F1),
    LIST_OL(0xE71F),
    LIST_SELECT(0xE656),
    LIST_UL(0xE7F0),
    LOCATION_ARROW(0xE728),
    LOCATION_ARROW_CIRCLE(0xE727),
    LOCATION_ARROW_CIRCLE_O(0xE726),
    LOCK(0xE7F2),
    MAGIC(0xE6B1),
    MAGNET(0xE787),
    MAILBOX(0xE729),
    MALE(0xE6B2),
    MAP_MARKER(0xE788),
    MARGIN(0xE65B),
    MARGIN_BOTTOM(0xE657),
    MARGIN_LEFT(0xE658),
    MARGIN_RIGHT(0xE659),
    MARGIN_TOP(0xE65A),
    MEDAL(0xE6B3),
    MEGAFONE(0xE6B4),
    MEH_O(0xE6B5),
    MENU(0xE7B3),
    MICROPHONE(0xE72A),
    MINUS(0xE7F6),
    MINUS_CIRCLE(0xE7F4),
    MINUS_CIRCLE_O(0xE7F3),
    MINUS_SQUARE_LEFT_O(0xE7F5),
    MOBILE(0xE7F7),
    MOBILE_BROWSER(0XE93D),
    MOBILE_RETRO(0XE93E),
    MODAL(0xE7F8),
    MODAL_LIST(0xE72B),
    MONEY(0xE6B6),
    MONEY_DEPOSIT(0XE93F),
    MONEY_EXCHANGE(0XE940),
    MONEY_WITHDRAW(0XE941),
    MOON(0xE78A),
    MOON_O(0xE789),
    MORNING(0XE942),
    MOVIE(0xE78B),
    MUSIC(0xE78C),
    MUTE(0xE72C),
    NATIVE_BUTTON(0xE65C),
    NEWSPAPER(0XE943),
    NOTEBOOK(0xE65D),
    NURSE(0XE944),
    OFFICE(0XE945),
    OPEN_BOOK(0xE7F9),
    OPTION(0XE947),
    OPTIONS(0xE65E),
    OPTION_A(0XE946),
    ORIENTATION(0xE65F),
    OUT(0xE614),
    OUTBOX(0xE660),
    PACKAGE(0xE6B7),
    PADDING(0xE665),
    PADDING_BOTTOM(0xE661),
    PADDING_LEFT(0xE662),
    PADDING_RIGHT(0xE663),
    PADDING_TOP(0xE664),
    PAINT_ROLL(0xE666),
    PAINTBRUSH(0xE6B8),
    PALETE(0xE667),
    PANEL(0xE668),
    PAPERCLIP(0xE72D),
    PAPERPLANE(0xE6B9),
    PAPERPLANE_O(0xE6BA),
    PARAGRAPH(0xE6BB),
    PASSWORD(0xE669),
    PASTE(0xE6BC),
    PAUSE(0xE78D),
    PENCIL(0xE7FA),
    PHONE(0xE7FB),
    PHONE_LANDLINE(0XE948),
    PICTURE(0xE7FC),
    PIE_BAR_CHART(0XE949),
    PIE_CHART(0xE6BD),
    PIGGY_BANK(0XE94B),
    PIGGY_BANK_COIN(0XE94A),
    PILL(0xE615),
    PILLS(0xE616),
    PIN(0xE7FD),
    PIN_POST(0xE6BE),
    PLAY(0xE78E),
    PLAY_CIRCLE(0xE731),
    PLAY_CIRCLE_O(0xE72E),
    PLUG(0xE66A),
    PLUS(0xE801),
    PLUS_CIRCLE(0xE7FF),
    PLUS_CIRCLE_O(0xE7FE),
    PLUS_MINUS(0xE603),
    PLUS_SQUARE_LEFT_O(0xE800),
    POINTER(0xE66B),
    POWER_OFF(0xE78F),
    PRESENTATION(0xE6BF),
    PRINT(0xE802),
    PROGRESSBAR(0xE66C),
    PUZZLE_PIECE(0xE6C0),
    PYRAMID_CHART(0XE94C),
    QRCODE(0xE6C1),
    QUESTION(0xE732),
    QUESTION_CIRCLE(0xE730),
    QUESTION_CIRCLE_O(0xE72F),
    QUOTE_LEFT(0xE6C2),
    QUOTE_RIGHT(0xE6C3),
    RANDOM(0xE733),
    RASTER(0xE6C5),
    RASTER_LOWER_LEFT(0xE6C4),
    RECORDS(0XE94D),
    RECYCLE(0xE6C6),
    REFRESH(0xE790),
    REPLY(0xE792),
    REPLY_ALL(0xE791),
    RESIZE_H(0xE66D),
    RESIZE_V(0xE66E),
    RETWEET(0xE793),
    RHOMBUS(0xE66F),
    ROAD(0xE6C7),
    ROAD_BRANCH(0xE670),
    ROAD_BRANCHES(0xE671),
    ROAD_SPLIT(0xE672),
    ROCKET(0xE6C8),
    ROTATE_LEFT(0xE794),
    ROTATE_RIGHT(0xE795),
    RSS(0xE6CA),
    RSS_SQUARE(0xE6C9),
    SAFE(0xE6CC),
    SAFE_LOCK(0xE6CB),
    SCALE(0XE94F),
    SCALE_UNBALANCE(0XE94E),
    SCATTER_CHART(0XE950),
    SCISSORS(0xE734),
    SCREWDRIVER(0xE735),
    SEARCH(0xE805),
    SEARCH_MINUS(0xE803),
    SEARCH_PLUS(0xE804),
    SELECT(0xE673),
    SERVER(0xE736),
    SHARE(0xE796),
    SHARE_SQUARE(0xE6CD),
    SHIELD(0xE6CE),
    SHIFT(0XE952),
    SHIFT_ARROW(0XE951),
    SHOP(0XE953),
    SIGN_IN(0xE797),
    SIGN_IN_ALT(0xE6B0),
    SIGN_OUT(0xE798),
    SIGN_OUT_ALT(0xE6AF),
    SIGNAL(0xE738),
    SITEMAP(0xE739),
    SLIDER(0xE674),
    SLIDERS(0xE6CF),
    SMILEY_O(0xE6D0),
    SORT(0xE799),
    SOUND_DISABLE(0xE79A),
    SPARK_LINE(0XE954),
    SPECIALIST(0xE617),
    SPINNER(0xE6D3),
    SPINNER_ARC(0xE6D1),
    SPINNER_THIRD(0xE6D2),
    SPLINE_AREA_CHART(0XE955),
    SPLINE_CHART(0XE956),
    SPLIT(0xE675),
    SPLIT_H(0xE807),
    SPLIT_V(0xE808),
    SPOON(0xE73A),
    SQUARE_SHADOW(0xE79B),
    STAR(0xE7A1),
    STAR_HALF_LEFT(0xE79D),
    STAR_HALF_LEFT_O(0xE79C),
    STAR_HALF_RIGHT(0xE79F),
    STAR_HALF_RIGHT_O(0xE79E),
    STAR_O(0xE7A0),
    START_COG(0xE676),
    STEP_BACKWARD(0xE7A2),
    STEP_FORWARD(0xE7A3),
    STETHOSCOPE(0xE618),
    STOCK(0XE957),
    STOP(0xE7A4),
    STOPWATCH(0XE958),
    STOP_COG(0xE677),
    STORAGE(0XE959),
    STRIKETHROUGH(0xE73B),
    SUBSCRIPT(0xE6D4),
    SUITCASE(0xE809),
    SUN_DOWN(0XE95A),
    SUN_O(0xE73C),
    SUN_RISE(0XE95B),
    SUPERSCRIPT(0xE6D5),
    SWORD(0xE678),
    TAB(0XE95D),
    TABLE(0xE7A5),
    TABLET(0xE80A),
    TABS(0xE679),
    TAB_A(0XE95C),
    TAG(0xE6D6),
    TAGS(0xE6D7),
    TASKS(0xE73D),
    TAXI(0xE67A),
    TEETH(0xE619),
    TERMINAL(0xE6D8),
    TEXT_HEIGHT(0xE73E),
    TEXT_INPUT(0xE67B),
    TEXT_LABEL(0xE67C),
    TEXT_WIDTH(0xE73F),
    THIN_SQUARE(0xE7A6),
    THUMBS_DOWN(0xE6DA),
    THUMBS_DOWN_O(0xE6D9),
    THUMBS_UP(0xE6DC),
    THUMBS_UP_O(0xE6DB),
    TICKET(0xE740),
    TIMER(0XE95E),
    TIME_BACKWARD(0xE7A7),
    TIME_FORWARD(0xE7A8),
    TOOLBOX(0xE741),
    TOOLS(0xE742),
    TOOTH(0xE67D),
    TOUCH(0XE95F),
    TRAIN(0xE67E),
    TRASH(0xE80B),
    TREE_TABLE(0xE67F),
    TRENDIND_DOWN(0XE960),
    TRENDING_UP(0XE961),
    TROPHY(0xE743),
    TRUCK(0xE6DD),
    TWIN_COL_SELECT(0xE680),
    TWITTER(0xE6DF),
    TWITTER_SQUARE(0xE6DE),
    UMBRELLA(0xE6E0),
    UNDERLINE(0xE744),
    UNLINK(0xE745),
    UNLOCK(0xE80C),
    UPLOAD(0xE746),
    UPLOAD_ALT(0xE6E1),
    USER(0xE80D),
    USER_CARD(0xE61A),
    USER_CHECK(0xE61B),
    USER_CLOCK(0xE61C),
    USER_HEART(0xE61D),
    USER_STAR(0XE962),
    USERS(0xE747),
    VAADIN_H(0xE80E),
    VAADIN_V(0xE80F),
    VIEWPORT(0xE681),
    VIMEO(0xE6E3),
    VIMEO_SQUARE(0xE6E2),
    VOLUME(0xE7AC),
    VOLUME_DOWN(0xE7A9),
    VOLUME_OFF(0xE7AA),
    VOLUME_UP(0xE7AB),
    WALLET(0XE963),
    WARNING(0xE748),
    WORKPLACE(0XE900),
    WRENCH(0xE749),
    YOUTUBE(0xE6E5),
    YOUTUBE_SQUARE(0xE6E4);

    private static final String fontFamily = "Vaadin-Icons";
    private int codepoint;

    VaadinIcons(int codepoint) {
        this.codepoint = codepoint;
    }

    @Override
    public String getMIMEType() {
        throw new UnsupportedOperationException(FontIcon.class.getSimpleName()
                + " should not be used where a MIME type is needed.");
    }

    @Override
    public String getFontFamily() {
        return fontFamily;
    }

    @Override
    public int getCodepoint() {
        return codepoint;
    }

    @Override
    public String getHtml() {
        return "<span class=\"v-icon v-icon-" + name().toLowerCase()
                + "\" style=\"font-family: " + fontFamily + ";\">&#x"
                + Integer.toHexString(codepoint) + ";</span>";
    }

}
