/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb;

import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.ververica.cdc.connectors.mongodb.internal.MongoDBConnectorSourceConnector;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import com.ververica.cdc.connectors.mongodb.source.utils.MongoUtils;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import com.ververica.cdc.debezium.Validator;
import io.debezium.heartbeat.Heartbeat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MongoDBSource {
    public static final String FULL_DOCUMENT_UPDATE_LOOKUP = FullDocument.UPDATE_LOOKUP.getValue();
    public static final String OUTPUT_FORMAT_SCHEMA = MongoSourceConfig.OutputFormat.SCHEMA.name().toLowerCase(Locale.ROOT);

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private String hosts;
        private String username;
        private String password;
        private List<String> databaseList;
        private List<String> collectionList;
        private String connectionOptions;
        private Integer batchSize = (Integer)MongoDBSourceOptions.BATCH_SIZE.defaultValue();
        private Integer pollAwaitTimeMillis = (Integer)MongoDBSourceOptions.POLL_AWAIT_TIME_MILLIS.defaultValue();
        private Integer pollMaxBatchSize = (Integer)MongoDBSourceOptions.POLL_MAX_BATCH_SIZE.defaultValue();
        private Boolean updateLookup = true;
        private Boolean copyExisting = (Boolean)MongoDBSourceOptions.COPY_EXISTING.defaultValue();
        private Integer copyExistingMaxThreads;
        private Integer copyExistingQueueSize;
        private String copyExistingPipeline;
        private Integer heartbeatIntervalMillis = (Integer)MongoDBSourceOptions.HEARTBEAT_INTERVAL_MILLIS.defaultValue();
        private DebeziumDeserializationSchema<T> deserializer;

        public Builder<T> hosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public Builder<T> connectionOptions(String connectionOptions) {
            this.connectionOptions = connectionOptions;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> databaseList(String ... databaseList) {
            this.databaseList = Arrays.asList(databaseList);
            return this;
        }

        public Builder<T> collectionList(String ... collectionList) {
            this.collectionList = Arrays.asList(collectionList);
            return this;
        }

        public Builder<T> batchSize(int batchSize) {
            Preconditions.checkArgument((batchSize >= 0 ? 1 : 0) != 0);
            this.batchSize = batchSize;
            return this;
        }

        public Builder<T> pollAwaitTimeMillis(int pollAwaitTimeMillis) {
            Preconditions.checkArgument((pollAwaitTimeMillis > 0 ? 1 : 0) != 0);
            this.pollAwaitTimeMillis = pollAwaitTimeMillis;
            return this;
        }

        public Builder<T> pollMaxBatchSize(int pollMaxBatchSize) {
            Preconditions.checkArgument((pollMaxBatchSize > 0 ? 1 : 0) != 0);
            this.pollMaxBatchSize = pollMaxBatchSize;
            return this;
        }

        public Builder<T> updateLookup(boolean updateLookup) {
            this.updateLookup = updateLookup;
            return this;
        }

        public Builder<T> copyExisting(boolean copyExisting) {
            this.copyExisting = copyExisting;
            return this;
        }

        public Builder<T> copyExistingMaxThreads(int copyExistingMaxThreads) {
            Preconditions.checkArgument((copyExistingMaxThreads > 0 ? 1 : 0) != 0);
            this.copyExistingMaxThreads = copyExistingMaxThreads;
            return this;
        }

        public Builder<T> copyExistingQueueSize(int copyExistingQueueSize) {
            Preconditions.checkArgument((copyExistingQueueSize > 0 ? 1 : 0) != 0);
            this.copyExistingQueueSize = copyExistingQueueSize;
            return this;
        }

        public Builder<T> copyExistingPipeline(String copyExistingPipeline) {
            this.copyExistingPipeline = copyExistingPipeline;
            return this;
        }

        public Builder<T> heartbeatIntervalMillis(int heartbeatIntervalMillis) {
            Preconditions.checkArgument((heartbeatIntervalMillis >= 0 ? 1 : 0) != 0);
            this.heartbeatIntervalMillis = heartbeatIntervalMillis;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public DebeziumSourceFunction<T> build() {
            Properties props = new Properties();
            props.setProperty("connector.class", MongoDBConnectorSourceConnector.class.getCanonicalName());
            props.setProperty("name", "mongodb_cdc_source");
            props.setProperty("connection.uri", String.valueOf(MongoUtils.buildConnectionString(this.username, this.password, this.hosts, this.connectionOptions)));
            if (this.databaseList != null) {
                props.setProperty("database.include.list", String.join((CharSequence)",", this.databaseList));
            }
            if (this.collectionList != null) {
                props.setProperty("collection.include.list", String.join((CharSequence)",", this.collectionList));
            }
            if (this.updateLookup.booleanValue()) {
                props.setProperty("change.stream.full.document", FULL_DOCUMENT_UPDATE_LOOKUP);
            }
            props.setProperty("publish.full.document.only", String.valueOf(Boolean.FALSE));
            props.setProperty("output.format.key", OUTPUT_FORMAT_SCHEMA);
            props.setProperty("output.format.value", OUTPUT_FORMAT_SCHEMA);
            props.setProperty("output.schema.infer.value", String.valueOf(Boolean.FALSE));
            props.setProperty("output.schema.value", "{  \"name\": \"ChangeStream\",  \"type\": \"record\",  \"fields\": [    { \"name\": \"_id\", \"type\": \"string\" },    { \"name\": \"operationType\", \"type\": [\"string\", \"null\"] },    { \"name\": \"fullDocument\", \"type\": [\"string\", \"null\"] },    { \"name\": \"source\",      \"type\": [{\"name\": \"source\", \"type\": \"record\", \"fields\": [                {\"name\": \"ts_ms\", \"type\": \"long\"},                {\"name\": \"snapshot\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"ts_ms\", \"type\": [\"long\", \"null\"]},    { \"name\": \"ns\",      \"type\": [{\"name\": \"ns\", \"type\": \"record\", \"fields\": [                {\"name\": \"db\", \"type\": \"string\"},                {\"name\": \"coll\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"to\",      \"type\": [{\"name\": \"to\", \"type\": \"record\",  \"fields\": [                {\"name\": \"db\", \"type\": \"string\"},                {\"name\": \"coll\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"documentKey\", \"type\": [\"string\", \"null\"] },    { \"name\": \"updateDescription\",      \"type\": [{\"name\": \"updateDescription\",  \"type\": \"record\", \"fields\": [                 {\"name\": \"updatedFields\", \"type\": [\"string\", \"null\"]},                 {\"name\": \"removedFields\",                  \"type\": [{\"type\": \"array\", \"items\": \"string\"}, \"null\"]                  }] }, \"null\"] },    { \"name\": \"clusterTime\", \"type\": [\"string\", \"null\"] },    { \"name\": \"txnNumber\", \"type\": [\"long\", \"null\"]},    { \"name\": \"lsid\", \"type\": [{\"name\": \"lsid\", \"type\": \"record\",               \"fields\": [ {\"name\": \"id\", \"type\": \"string\"},                             {\"name\": \"uid\", \"type\": \"string\"}] }, \"null\"] }  ]}");
            if (this.batchSize != null) {
                props.setProperty("batch.size", String.valueOf(this.batchSize));
            }
            if (this.pollAwaitTimeMillis != null) {
                props.setProperty("poll.await.time.ms", String.valueOf(this.pollAwaitTimeMillis));
            }
            if (this.pollMaxBatchSize != null) {
                props.setProperty("poll.max.batch.size", String.valueOf(this.pollMaxBatchSize));
            }
            if (this.copyExisting != null) {
                props.setProperty("copy.existing", String.valueOf(this.copyExisting));
            }
            if (this.copyExistingMaxThreads != null) {
                props.setProperty("copy.existing.max.threads", String.valueOf(this.copyExistingMaxThreads));
            }
            if (this.copyExistingQueueSize != null) {
                props.setProperty("copy.existing.queue.size", String.valueOf(this.copyExistingQueueSize));
            }
            if (this.copyExistingPipeline != null) {
                props.setProperty("copy.existing.pipeline", this.copyExistingPipeline);
            }
            if (this.heartbeatIntervalMillis != null) {
                props.setProperty("heartbeat.interval.ms", String.valueOf(this.heartbeatIntervalMillis));
            }
            props.setProperty("heartbeat.topic.name", "__mongodb_heartbeats");
            props.setProperty(Heartbeat.HEARTBEAT_TOPICS_PREFIX.name(), "__mongodb_heartbeats");
            props.setProperty("errors.log.enable", String.valueOf(Boolean.TRUE));
            props.setProperty("errors.tolerance", MongoSourceConfig.ErrorTolerance.NONE.value());
            return new DebeziumSourceFunction(this.deserializer, props, null, Validator.getDefaultValidator());
        }
    }
}

