/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.assigners.splitters;

import com.ververica.cdc.connectors.base.source.meta.split.SnapshotSplit;
import com.ververica.cdc.connectors.mongodb.source.assigners.splitters.SplitContext;
import com.ververica.cdc.connectors.mongodb.source.assigners.splitters.SplitStrategy;
import com.ververica.cdc.connectors.mongodb.source.dialect.MongoDBDialect;
import com.ververica.cdc.connectors.mongodb.source.utils.ChunkUtils;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.annotation.Internal;

@Internal
public class SingleSplitStrategy
implements SplitStrategy {
    public static final SingleSplitStrategy INSTANCE = new SingleSplitStrategy();

    private SingleSplitStrategy() {
    }

    @Override
    public Collection<SnapshotSplit> split(SplitContext splitContext) {
        TableId collectionId = splitContext.getCollectionId();
        HashMap<TableId, TableChanges.TableChange> schema = new HashMap<TableId, TableChanges.TableChange>();
        schema.put(collectionId, MongoDBDialect.collectionSchema(collectionId));
        SnapshotSplit snapshotSplit = new SnapshotSplit(collectionId, this.splitId(collectionId, 0), this.shardKeysToRowType(Collections.singleton("_id")), ChunkUtils.minLowerBoundOfId(), ChunkUtils.maxUpperBoundOfId(), null, schema);
        return Collections.singletonList(snapshotSplit);
    }
}

