/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.config;

import com.ververica.cdc.connectors.base.config.SourceConfig;
import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.mongodb.source.utils.MongoUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

public class MongoDBSourceConfig
implements SourceConfig {
    private static final long serialVersionUID = 1L;
    private final String hosts;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final List<String> databaseList;
    @Nullable
    private final List<String> collectionList;
    private final String connectionString;
    private final int batchSize;
    private final int pollAwaitTimeMillis;
    private final int pollMaxBatchSize;
    private final boolean updateLookup;
    private final StartupOptions startupOptions;
    private final int heartbeatIntervalMillis;
    private final int splitMetaGroupSize;
    private final int splitSizeMB;

    MongoDBSourceConfig(String hosts, @Nullable String username, @Nullable String password, @Nullable List<String> databaseList, @Nullable List<String> collectionList, @Nullable String connectionOptions, int batchSize, int pollAwaitTimeMillis, int pollMaxBatchSize, boolean updateLookup, StartupOptions startupOptions, int heartbeatIntervalMillis, int splitMetaGroupSize, int splitSizeMB) {
        this.hosts = (String)Preconditions.checkNotNull((Object)hosts);
        this.username = username;
        this.password = password;
        this.databaseList = databaseList;
        this.collectionList = collectionList;
        this.connectionString = MongoUtils.buildConnectionString(username, password, hosts, connectionOptions).getConnectionString();
        this.batchSize = batchSize;
        this.pollAwaitTimeMillis = pollAwaitTimeMillis;
        this.pollMaxBatchSize = pollMaxBatchSize;
        this.updateLookup = updateLookup;
        this.startupOptions = startupOptions;
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.splitSizeMB = splitSizeMB;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public List<String> getDatabaseList() {
        return this.databaseList;
    }

    @Nullable
    public List<String> getCollectionList() {
        return this.collectionList;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getPollAwaitTimeMillis() {
        return this.pollAwaitTimeMillis;
    }

    public int getPollMaxBatchSize() {
        return this.pollMaxBatchSize;
    }

    public int getHeartbeatIntervalMillis() {
        return this.heartbeatIntervalMillis;
    }

    public boolean isUpdateLookup() {
        return this.updateLookup;
    }

    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    public int getSplitSize() {
        return this.splitSizeMB;
    }

    public int getSplitMetaGroupSize() {
        return this.splitMetaGroupSize;
    }

    public boolean isIncludeSchemaChanges() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDBSourceConfig that = (MongoDBSourceConfig)o;
        return this.batchSize == that.batchSize && this.pollAwaitTimeMillis == that.pollAwaitTimeMillis && this.pollMaxBatchSize == that.pollMaxBatchSize && this.updateLookup == that.updateLookup && this.startupOptions == that.startupOptions && this.heartbeatIntervalMillis == that.heartbeatIntervalMillis && this.splitMetaGroupSize == that.splitMetaGroupSize && this.splitSizeMB == that.splitSizeMB && Objects.equals(this.hosts, that.hosts) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.databaseList, that.databaseList) && Objects.equals(this.collectionList, that.collectionList) && Objects.equals(this.connectionString, that.connectionString);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.username, this.password, this.databaseList, this.collectionList, this.connectionString, this.batchSize, this.pollAwaitTimeMillis, this.pollMaxBatchSize, this.updateLookup, this.startupOptions, this.heartbeatIntervalMillis, this.splitMetaGroupSize, this.splitSizeMB);
    }
}

