/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.offset;

import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.mongodb.source.utils.MongoRecordUtils;
import com.ververica.cdc.connectors.mongodb.source.utils.ResumeTokenUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public class ChangeStreamOffset
extends Offset {
    private static final long serialVersionUID = 1L;
    public static final String TIMESTAMP_FIELD = "timestamp";
    public static final String RESUME_TOKEN_FIELD = "resumeToken";
    public static final ChangeStreamOffset NO_STOPPING_OFFSET = new ChangeStreamOffset(MongoRecordUtils.maximumBsonTimestamp());

    public ChangeStreamOffset(Map<String, String> offset) {
        this.offset = offset;
    }

    public ChangeStreamOffset(BsonDocument resumeToken) {
        Objects.requireNonNull(resumeToken);
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put(TIMESTAMP_FIELD, String.valueOf(ResumeTokenUtils.decodeTimestamp(resumeToken).getValue()));
        offsetMap.put(RESUME_TOKEN_FIELD, resumeToken.toJson());
        this.offset = offsetMap;
    }

    public ChangeStreamOffset(BsonTimestamp timestamp) {
        Objects.requireNonNull(timestamp);
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put(TIMESTAMP_FIELD, String.valueOf(timestamp.getValue()));
        offsetMap.put(RESUME_TOKEN_FIELD, null);
        this.offset = offsetMap;
    }

    public void updatePosition(BsonDocument resumeToken) {
        Objects.requireNonNull(resumeToken);
        this.offset.put(TIMESTAMP_FIELD, String.valueOf(ResumeTokenUtils.decodeTimestamp(resumeToken).getValue()));
        this.offset.put(RESUME_TOKEN_FIELD, resumeToken.toJson());
    }

    @Nullable
    public BsonDocument getResumeToken() {
        String resumeTokenJson = (String)this.offset.get(RESUME_TOKEN_FIELD);
        return Optional.ofNullable(resumeTokenJson).map(BsonDocument::parse).orElse(null);
    }

    public BsonTimestamp getTimestamp() {
        long timestamp = Long.parseLong((String)this.offset.get(TIMESTAMP_FIELD));
        return new BsonTimestamp(timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeStreamOffset)) {
            return false;
        }
        ChangeStreamOffset that = (ChangeStreamOffset)((Object)o);
        return this.offset.equals(that.offset);
    }

    public int compareTo(Offset offset) {
        if (offset == null) {
            return -1;
        }
        ChangeStreamOffset that = (ChangeStreamOffset)offset;
        return this.getTimestamp().compareTo(that.getTimestamp());
    }
}

