/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.reader.fetch;

import com.mongodb.client.model.changestream.OperationType;
import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.reader.external.FetchTask;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import com.ververica.cdc.connectors.mongodb.source.dialect.MongoDBDialect;
import com.ververica.cdc.connectors.mongodb.source.offset.ChangeStreamDescriptor;
import com.ververica.cdc.connectors.mongodb.source.offset.ChangeStreamOffset;
import com.ververica.cdc.connectors.mongodb.source.utils.BsonUtils;
import com.ververica.cdc.connectors.mongodb.source.utils.MongoRecordUtils;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.LoggingContext;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;

public class MongoDBFetchTaskContext
implements FetchTask.Context {
    private final MongoDBDialect dialect;
    private final MongoDBSourceConfig sourceConfig;
    private final ChangeStreamDescriptor changeStreamDescriptor;
    private ChangeEventQueue<DataChangeEvent> changeEventQueue;

    public MongoDBFetchTaskContext(MongoDBDialect dialect, MongoDBSourceConfig sourceConfig, ChangeStreamDescriptor changeStreamDescriptor) {
        this.dialect = dialect;
        this.sourceConfig = sourceConfig;
        this.changeStreamDescriptor = changeStreamDescriptor;
    }

    public void configure(SourceSplitBase sourceSplitBase) {
        int queueSize = sourceSplitBase.isSnapshotSplit() ? Integer.MAX_VALUE : this.sourceConfig.getBatchSize();
        this.changeEventQueue = new ChangeEventQueue.Builder().pollInterval(Duration.ofMillis(this.sourceConfig.getPollAwaitTimeMillis())).maxBatchSize(this.sourceConfig.getPollMaxBatchSize()).maxQueueSize(queueSize).loggingContextSupplier(() -> LoggingContext.forConnector((String)"mongodb-cdc", (String)"mongodb-cdc-connector", (String)"mongodb-cdc-connector-task")).build();
    }

    public MongoDBSourceConfig getSourceConfig() {
        return this.sourceConfig;
    }

    public MongoDBDialect getDialect() {
        return this.dialect;
    }

    public ChangeStreamDescriptor getChangeStreamDescriptor() {
        return this.changeStreamDescriptor;
    }

    public ChangeEventQueue<DataChangeEvent> getQueue() {
        return this.changeEventQueue;
    }

    public TableId getTableId(SourceRecord record) {
        return MongoRecordUtils.getTableId(record);
    }

    public Tables.TableFilter getTableFilter() {
        return Tables.TableFilter.includeAll();
    }

    public Offset getStreamOffset(SourceRecord record) {
        return new ChangeStreamOffset(MongoRecordUtils.getResumeToken(record));
    }

    public boolean isDataChangeRecord(SourceRecord record) {
        return MongoRecordUtils.isDataChangeRecord(record);
    }

    public boolean isRecordBetween(SourceRecord record, Object[] splitStart, Object[] splitEnd) {
        BsonDocument documentKey = MongoRecordUtils.getDocumentKey(record);
        BsonDocument splitKeys = (BsonDocument)splitStart[0];
        String firstKey = splitKeys.getFirstKey();
        BsonValue keyValue = documentKey.get((Object)firstKey);
        BsonValue lowerBound = ((BsonDocument)splitEnd[1]).get((Object)firstKey);
        BsonValue upperBound = ((BsonDocument)splitEnd[1]).get((Object)firstKey);
        if (lowerBound.getBsonType() == BsonType.MIN_KEY && upperBound.getBsonType() == BsonType.MAX_KEY) {
            return true;
        }
        return BsonUtils.compareBsonValue(lowerBound, keyValue) <= 0 && BsonUtils.compareBsonValue(keyValue, upperBound) < 0;
    }

    public void rewriteOutputBuffer(Map<Struct, SourceRecord> outputBuffer, SourceRecord changeRecord) {
        Struct key = (Struct)changeRecord.key();
        Struct value = (Struct)changeRecord.value();
        if (value != null) {
            OperationType operation = OperationType.fromString((String)value.getString("operationType"));
            switch (operation) {
                case INSERT: 
                case UPDATE: 
                case REPLACE: {
                    outputBuffer.put(key, changeRecord);
                    break;
                }
                case DELETE: {
                    outputBuffer.remove(key);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Data change record meet UNKNOWN operation, the the record is %s.", changeRecord));
                }
            }
        }
    }

    public List<SourceRecord> formatMessageTimestamp(Collection<SourceRecord> snapshotRecords) {
        return snapshotRecords.stream().peek(record -> {
            Struct value = (Struct)record.value();
            Struct source = new Struct(value.schema().field("source").schema());
            source.put("ts_ms", (Object)0L);
            source.put("snapshot", (Object)"true");
            value.put("source", (Object)source);
        }).collect(Collectors.toList());
    }
}

