/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.utils;

import com.mongodb.ConnectionString;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.ververica.cdc.connectors.mongodb.internal.MongoDBEnvelope;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import com.ververica.cdc.connectors.mongodb.source.connection.MongoClientPool;
import com.ververica.cdc.connectors.mongodb.source.offset.ChangeStreamDescriptor;
import com.ververica.cdc.connectors.mongodb.source.utils.CollectionDiscoveryUtils;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.util.Preconditions;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MongoUtils.class);
    public static final BsonDouble COMMAND_SUCCEED_FLAG = new BsonDouble(1.0);
    public static final int FAILED_TO_PARSE_ERROR = 9;
    public static final int UNAUTHORIZED_ERROR = 13;
    public static final int ILLEGAL_OPERATION_ERROR = 20;
    public static final int UNKNOWN_FIELD_ERROR = 40415;

    private MongoUtils() {
    }

    public static ChangeStreamDescriptor getChangeStreamDescriptor(MongoDBSourceConfig sourceConfig, List<String> discoveredDatabases, List<String> discoveredCollections) {
        ChangeStreamDescriptor changeStreamFilter;
        List<String> databaseList = sourceConfig.getDatabaseList();
        List<String> collectionList = sourceConfig.getCollectionList();
        if (collectionList != null) {
            if (CollectionDiscoveryUtils.isIncludeListExplicitlySpecified(collectionList, discoveredCollections)) {
                changeStreamFilter = ChangeStreamDescriptor.collection(TableId.parse((String)discoveredCollections.get(0)));
            } else {
                Pattern namespaceRegex = CollectionDiscoveryUtils.includeListAsFlatPattern(collectionList);
                if (databaseList != null) {
                    if (CollectionDiscoveryUtils.isIncludeListExplicitlySpecified(databaseList, discoveredDatabases)) {
                        changeStreamFilter = ChangeStreamDescriptor.database(discoveredDatabases.get(0), namespaceRegex);
                    } else {
                        Pattern databaseRegex = CollectionDiscoveryUtils.includeListAsFlatPattern(databaseList);
                        changeStreamFilter = ChangeStreamDescriptor.deployment(databaseRegex, namespaceRegex);
                    }
                } else {
                    changeStreamFilter = ChangeStreamDescriptor.deployment(null, namespaceRegex);
                }
            }
        } else if (databaseList != null) {
            if (CollectionDiscoveryUtils.isIncludeListExplicitlySpecified(databaseList, discoveredDatabases)) {
                changeStreamFilter = ChangeStreamDescriptor.database(discoveredDatabases.get(0));
            } else {
                Pattern databaseRegex = CollectionDiscoveryUtils.includeListAsFlatPattern(databaseList);
                changeStreamFilter = ChangeStreamDescriptor.deployment(databaseRegex);
            }
        } else {
            changeStreamFilter = ChangeStreamDescriptor.deployment();
        }
        return changeStreamFilter;
    }

    public static ChangeStreamIterable<Document> getChangeStreamIterable(MongoDBSourceConfig sourceConfig, ChangeStreamDescriptor descriptor) {
        return MongoUtils.getChangeStreamIterable(MongoUtils.clientFor(sourceConfig), descriptor.getDatabase(), descriptor.getCollection(), descriptor.getDatabaseRegex(), descriptor.getNamespaceRegex(), sourceConfig.getBatchSize(), sourceConfig.isUpdateLookup());
    }

    public static ChangeStreamIterable<Document> getChangeStreamIterable(MongoClient mongoClient, ChangeStreamDescriptor descriptor, int batchSize, boolean updateLookup) {
        return MongoUtils.getChangeStreamIterable(mongoClient, descriptor.getDatabase(), descriptor.getCollection(), descriptor.getDatabaseRegex(), descriptor.getNamespaceRegex(), batchSize, updateLookup);
    }

    public static ChangeStreamIterable<Document> getChangeStreamIterable(MongoClient mongoClient, @Nullable String database, @Nullable String collection, @Nullable Pattern databaseRegex, @Nullable Pattern namespaceRegex, int batchSize, boolean updateLookup) {
        ChangeStreamIterable changeStream;
        if (StringUtils.isNotEmpty((CharSequence)database) && StringUtils.isNotEmpty((CharSequence)collection)) {
            MongoCollection coll = mongoClient.getDatabase(database).getCollection(collection);
            LOG.info("Preparing change stream for collection {}.{}", (Object)database, (Object)collection);
            changeStream = coll.watch();
        } else if (StringUtils.isNotEmpty((CharSequence)database) && namespaceRegex != null) {
            MongoDatabase db = mongoClient.getDatabase(database);
            ArrayList<Bson> pipeline = new ArrayList<Bson>();
            pipeline.add(CollectionDiscoveryUtils.ADD_NS_FIELD);
            Bson nsFilter = Filters.regex((String)"_ns_", (Pattern)namespaceRegex);
            pipeline.add(Aggregates.match((Bson)nsFilter));
            LOG.info("Preparing change stream for database {} with namespace regex filter {}", (Object)database, (Object)namespaceRegex);
            changeStream = db.watch(pipeline);
        } else if (StringUtils.isNotEmpty((CharSequence)database)) {
            MongoDatabase db = mongoClient.getDatabase(database);
            LOG.info("Preparing change stream for database {}", (Object)database);
            changeStream = db.watch();
        } else if (namespaceRegex != null) {
            ArrayList<Bson> pipeline = new ArrayList<Bson>();
            pipeline.add(CollectionDiscoveryUtils.ADD_NS_FIELD);
            Bson nsFilter = Filters.regex((String)"_ns_", (Pattern)namespaceRegex);
            if (databaseRegex != null) {
                Bson dbFilter = Filters.regex((String)"ns.db", (Pattern)databaseRegex);
                nsFilter = Filters.and((Bson[])new Bson[]{dbFilter, nsFilter});
                LOG.info("Preparing change stream for deployment with database regex filter {} and namespace regex filter {}", (Object)databaseRegex, (Object)namespaceRegex);
            } else {
                LOG.info("Preparing change stream for deployment with namespace regex filter {}", (Object)namespaceRegex);
            }
            pipeline.add(Aggregates.match((Bson)nsFilter));
            changeStream = mongoClient.watch(pipeline);
        } else if (databaseRegex != null) {
            ArrayList<Bson> pipeline = new ArrayList<Bson>();
            pipeline.add(Aggregates.match((Bson)Filters.regex((String)"ns.db", (Pattern)databaseRegex)));
            LOG.info("Preparing change stream for deployment  with database regex filter {}", (Object)databaseRegex);
            changeStream = mongoClient.watch(pipeline);
        } else {
            LOG.info("Preparing change stream for deployment");
            changeStream = mongoClient.watch();
        }
        if (batchSize > 0) {
            changeStream.batchSize(batchSize);
        }
        if (updateLookup) {
            changeStream.fullDocument(FullDocument.UPDATE_LOOKUP);
        }
        return changeStream;
    }

    @Nullable
    public static BsonDocument getLatestResumeToken(MongoClient mongoClient, ChangeStreamDescriptor descriptor) {
        ChangeStreamIterable<Document> changeStreamIterable = MongoUtils.getChangeStreamIterable(mongoClient, descriptor, 1, false);
        try (MongoChangeStreamCursor changeStreamCursor = changeStreamIterable.cursor();){
            ChangeStreamDocument firstResult = (ChangeStreamDocument)changeStreamCursor.tryNext();
            BsonDocument bsonDocument = firstResult != null ? firstResult.getResumeToken() : changeStreamCursor.getResumeToken();
            return bsonDocument;
        }
    }

    public static boolean isCommandSucceed(BsonDocument commandResult) {
        return commandResult != null && COMMAND_SUCCEED_FLAG.equals((Object)commandResult.getDouble((Object)"ok"));
    }

    public static String commandErrorMessage(BsonDocument commandResult) {
        return Optional.ofNullable(commandResult).map(doc -> doc.getString((Object)"errmsg")).map(BsonString::getValue).orElse(null);
    }

    public static BsonDocument collStats(MongoClient mongoClient, TableId collectionId) {
        BsonDocument collStatsCommand = new BsonDocument("collStats", (BsonValue)new BsonString(collectionId.table()));
        return (BsonDocument)mongoClient.getDatabase(collectionId.catalog()).runCommand((Bson)collStatsCommand, BsonDocument.class);
    }

    public static BsonDocument splitVector(MongoClient mongoClient, TableId collectionId, BsonDocument keyPattern, int maxChunkSizeMB) {
        return MongoUtils.splitVector(mongoClient, collectionId, keyPattern, maxChunkSizeMB, null, null);
    }

    public static BsonDocument splitVector(MongoClient mongoClient, TableId collectionId, BsonDocument keyPattern, int maxChunkSizeMB, @Nullable BsonDocument min, @Nullable BsonDocument max) {
        BsonDocument splitVectorCommand = new BsonDocument("splitVector", (BsonValue)new BsonString(collectionId.identifier())).append("keyPattern", (BsonValue)keyPattern).append("maxChunkSize", (BsonValue)new BsonInt32(maxChunkSizeMB));
        Optional.ofNullable(min).ifPresent(v -> splitVectorCommand.append("min", (BsonValue)v));
        Optional.ofNullable(max).ifPresent(v -> splitVectorCommand.append("max", (BsonValue)v));
        return (BsonDocument)mongoClient.getDatabase(collectionId.catalog()).runCommand((Bson)splitVectorCommand, BsonDocument.class);
    }

    public static BsonTimestamp getCurrentClusterTime(MongoClient mongoClient) {
        BsonDocument isMasterResult = MongoUtils.isMaster(mongoClient);
        if (!MongoUtils.isCommandSucceed(isMasterResult)) {
            throw new IllegalStateException("Failed to execute isMaster command: " + MongoUtils.commandErrorMessage(isMasterResult));
        }
        return isMasterResult.getDocument((Object)"$clusterTime").getTimestamp((Object)"clusterTime");
    }

    public static BsonDocument isMaster(MongoClient mongoClient) {
        BsonDocument isMasterCommand = new BsonDocument("isMaster", (BsonValue)new BsonInt32(1));
        return (BsonDocument)mongoClient.getDatabase("admin").runCommand((Bson)isMasterCommand, BsonDocument.class);
    }

    public static List<BsonDocument> readChunks(MongoClient mongoClient, BsonDocument collectionMetadata) {
        MongoCollection<BsonDocument> chunks = MongoUtils.collectionFor(mongoClient, TableId.parse((String)"config.chunks"), BsonDocument.class);
        ArrayList<BsonDocument> collectionChunks = new ArrayList<BsonDocument>();
        Bson filter = Filters.or((Bson[])new Bson[]{new BsonDocument("ns", collectionMetadata.get((Object)"_id")), new BsonDocument("uuid", collectionMetadata.get((Object)"uuid"))});
        chunks.find(filter).projection(Projections.include((String[])new String[]{"min", "max", "shard"})).sort(Sorts.ascending((String[])new String[]{"min"})).into(collectionChunks);
        return collectionChunks;
    }

    @Nullable
    public static BsonDocument readCollectionMetadata(MongoClient mongoClient, TableId collectionId) {
        MongoCollection<BsonDocument> collection = MongoUtils.collectionFor(mongoClient, TableId.parse((String)"config.collections"), BsonDocument.class);
        return (BsonDocument)collection.find(Filters.eq((String)"_id", (Object)collectionId.identifier())).projection(Projections.include((String[])new String[]{"_id", "uuid", "dropped", "key"})).first();
    }

    public static <T> MongoCollection<T> collectionFor(MongoClient mongoClient, TableId collectionId, Class<T> documentClass) {
        return mongoClient.getDatabase(collectionId.catalog()).getCollection(collectionId.table()).withDocumentClass(documentClass);
    }

    public static MongoClient clientFor(MongoDBSourceConfig sourceConfig) {
        return MongoClientPool.getInstance().getOrCreateMongoClient(sourceConfig);
    }

    public static ConnectionString buildConnectionString(@Nullable String username, @Nullable String password, String hosts, @Nullable String connectionOptions) {
        StringBuilder sb = new StringBuilder("mongodb").append("://");
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            sb.append(MongoDBEnvelope.encodeValue(username)).append(":").append(MongoDBEnvelope.encodeValue(password)).append("@");
        }
        sb.append((String)Preconditions.checkNotNull((Object)hosts));
        if (StringUtils.isNotEmpty((CharSequence)connectionOptions)) {
            sb.append("/?").append(connectionOptions);
        }
        return new ConnectionString(sb.toString());
    }
}

