/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.table;

import com.ververica.cdc.connectors.base.options.SourceOptions;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import com.ververica.cdc.connectors.mongodb.table.MongoDBTableSource;
import com.ververica.cdc.debezium.utils.ResolvedSchemaUtils;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;

public class MongoDBTableSourceFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "mongodb-cdc";
    private static final String DOCUMENT_ID_FIELD = "_id";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        ReadableConfig config = helper.getOptions();
        String hosts = (String)config.get(MongoDBSourceOptions.HOSTS);
        String connectionOptions = config.getOptional(MongoDBSourceOptions.CONNECTION_OPTIONS).orElse(null);
        String username = config.getOptional(MongoDBSourceOptions.USERNAME).orElse(null);
        String password = config.getOptional(MongoDBSourceOptions.PASSWORD).orElse(null);
        String database = config.getOptional(MongoDBSourceOptions.DATABASE).orElse(null);
        String collection = config.getOptional(MongoDBSourceOptions.COLLECTION).orElse(null);
        Integer batchSize = (Integer)config.get(MongoDBSourceOptions.BATCH_SIZE);
        Integer pollMaxBatchSize = (Integer)config.get(MongoDBSourceOptions.POLL_MAX_BATCH_SIZE);
        Integer pollAwaitTimeMillis = (Integer)config.get(MongoDBSourceOptions.POLL_AWAIT_TIME_MILLIS);
        Integer heartbeatIntervalMillis = (Integer)config.get(MongoDBSourceOptions.HEARTBEAT_INTERVAL_MILLIS);
        Boolean copyExisting = (Boolean)config.get(MongoDBSourceOptions.COPY_EXISTING);
        Integer copyExistingQueueSize = config.getOptional(MongoDBSourceOptions.COPY_EXISTING_QUEUE_SIZE).orElse(null);
        String zoneId = (String)context.getConfiguration().get(TableConfigOptions.LOCAL_TIME_ZONE);
        ZoneId localTimeZone = ((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zoneId) ? ZoneId.systemDefault() : ZoneId.of(zoneId);
        boolean enableParallelRead = (Boolean)config.get(MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        int splitSizeMB = (Integer)config.get(MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB);
        int splitMetaGroupSize = (Integer)config.get(SourceOptions.CHUNK_META_GROUP_SIZE);
        ResolvedSchema physicalSchema = ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)context.getCatalogTable().getResolvedSchema());
        Preconditions.checkArgument((boolean)physicalSchema.getPrimaryKey().isPresent(), (Object)"Primary key must be present");
        this.checkPrimaryKey((UniqueConstraint)physicalSchema.getPrimaryKey().get(), "Primary key must be _id field");
        return new MongoDBTableSource(physicalSchema, hosts, username, password, database, collection, connectionOptions, copyExisting, copyExistingQueueSize, batchSize, pollMaxBatchSize, pollAwaitTimeMillis, heartbeatIntervalMillis, localTimeZone, enableParallelRead, splitMetaGroupSize, splitSizeMB);
    }

    private void checkPrimaryKey(UniqueConstraint pk, String message) {
        Preconditions.checkArgument((pk.getColumns().size() == 1 && pk.getColumns().contains(DOCUMENT_ID_FIELD) ? 1 : 0) != 0, (Object)message);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(MongoDBSourceOptions.HOSTS);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(MongoDBSourceOptions.USERNAME);
        options.add(MongoDBSourceOptions.PASSWORD);
        options.add(MongoDBSourceOptions.CONNECTION_OPTIONS);
        options.add(MongoDBSourceOptions.DATABASE);
        options.add(MongoDBSourceOptions.COLLECTION);
        options.add(MongoDBSourceOptions.COPY_EXISTING);
        options.add(MongoDBSourceOptions.COPY_EXISTING_QUEUE_SIZE);
        options.add(MongoDBSourceOptions.BATCH_SIZE);
        options.add(MongoDBSourceOptions.POLL_MAX_BATCH_SIZE);
        options.add(MongoDBSourceOptions.POLL_AWAIT_TIME_MILLIS);
        options.add(MongoDBSourceOptions.HEARTBEAT_INTERVAL_MILLIS);
        options.add(MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        options.add(MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB);
        options.add(SourceOptions.CHUNK_META_GROUP_SIZE);
        return options;
    }
}

